/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.flyway.core.sql;

import com.google.code.flyway.core.Migration;
import com.google.code.flyway.core.MigrationResolver;
import com.google.code.flyway.core.sql.SqlMigration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class SqlMigrationResolver
implements MigrationResolver {
    private static final Log log = LogFactory.getLog(SqlMigrationResolver.class);
    private final PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
    private final String baseDir;
    private final Map<String, String> placeholders;

    public SqlMigrationResolver(String baseDir, Map<String, String> placeholders) {
        this.baseDir = baseDir;
        this.placeholders = placeholders == null ? new HashMap<String, String>() : placeholders;
    }

    @Override
    public Collection<Migration> resolvesMigrations() {
        ArrayList<Migration> migrations = new ArrayList<Migration>();
        ClassPathResource classPathBaseDir = new ClassPathResource(this.baseDir + "/");
        if (!classPathBaseDir.exists()) {
            log.warn((Object)("Unable to find path for sql migrations: " + this.baseDir));
            return migrations;
        }
        try {
            Resource[] resources;
            for (Resource resource : resources = this.pathMatchingResourcePatternResolver.getResources("classpath:" + this.baseDir + "/V?*.sql")) {
                migrations.add(new SqlMigration(resource, this.placeholders));
            }
        }
        catch (IOException e) {
            log.error((Object)"Error loading sql migration files", (Throwable)e);
        }
        return migrations;
    }
}

