/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util.scanner;

import com.googlecode.flyway.core.util.ClassPathResource;
import com.googlecode.flyway.core.util.scanner.FileSystemLocationScanner;
import com.googlecode.flyway.core.util.scanner.JarFileLocationScanner;
import com.googlecode.flyway.core.util.scanner.LocationScanner;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathScanner {
    private static final Log LOG = LogFactory.getLog(ClassPathScanner.class);
    private static final List<LocationScanner> LOCATION_SCANNERS = new ArrayList<LocationScanner>();

    public ClassPathResource[] scanForResources(String location, String prefix, String suffix) throws IOException {
        TreeSet<ClassPathResource> classPathResources = new TreeSet<ClassPathResource>();
        Set<String> resourceNames = this.findResourceNames(location, prefix, suffix);
        for (String resourceName : resourceNames) {
            classPathResources.add(new ClassPathResource(resourceName));
            LOG.debug((Object)("Found resource: " + resourceName));
        }
        return classPathResources.toArray(new ClassPathResource[classPathResources.size()]);
    }

    public Class<?>[] scanForClasses(String location, Class<?> ... implementedInterfaces) throws Exception {
        ArrayList classes = new ArrayList();
        Set<String> resourceNames = this.findResourceNames(location, "", ".class");
        for (String resourceName : resourceNames) {
            String className = this.toClassName(resourceName);
            Class<?> clazz = this.getClassLoader().loadClass(className);
            if (implementedInterfaces.length == 0) {
                classes.add(clazz);
                continue;
            }
            for (Class<?> implementedInterface : implementedInterfaces) {
                if (!implementedInterface.isAssignableFrom(clazz)) continue;
                classes.add(clazz);
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private String toClassName(String resourceName) {
        String nameWithDots = resourceName.replace("/", ".");
        return nameWithDots.substring(0, nameWithDots.length() - ".class".length());
    }

    private Set<String> findResourceNames(String location, String prefix, String suffix) throws IOException {
        TreeSet<String> resourceNames = new TreeSet<String>();
        String normalizedLocation = this.normalizeLocation(location);
        Enumeration<URL> locationsUrls = this.getClassLoader().getResources(normalizedLocation);
        if (!locationsUrls.hasMoreElements()) {
            LOG.debug((Object)("Unable to determine URL for classpath location: " + normalizedLocation + " (ClassLoader: " + this.getClassLoader() + ")"));
        }
        while (locationsUrls.hasMoreElements()) {
            URL locationUrl = locationsUrls.nextElement();
            LOG.debug((Object)("Scanning URL: " + locationUrl.toExternalForm()));
            String scanRoot = URLDecoder.decode(locationUrl.getFile(), "UTF-8");
            if (scanRoot.endsWith("/")) {
                scanRoot = scanRoot.substring(0, scanRoot.length() - 1);
            }
            boolean accepted = false;
            for (LocationScanner locationScanner : LOCATION_SCANNERS) {
                if (!locationScanner.acceptUrlProtocol(locationUrl.getProtocol())) continue;
                accepted = true;
                resourceNames.addAll(locationScanner.findResourceNames(normalizedLocation, scanRoot));
            }
            if (accepted) continue;
            LOG.warn((Object)("Unable to scan location: " + scanRoot + " (unsupported protocol: " + locationUrl.getProtocol() + ")"));
        }
        return this.filterResourceNames(resourceNames, prefix, suffix);
    }

    private String normalizeLocation(String location) {
        String directory = location.replace(".", "/").replace("\\", "/");
        if (directory.startsWith("/")) {
            directory = directory.substring(1);
        }
        if (directory.endsWith("/")) {
            directory = directory.substring(0, directory.length() - 1);
        }
        return directory;
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private Set<String> filterResourceNames(Set<String> resourceNames, String prefix, String suffix) {
        TreeSet<String> filteredResourceNames = new TreeSet<String>();
        for (String resourceName : resourceNames) {
            String fileName = resourceName.substring(resourceName.lastIndexOf("/") + 1);
            if (fileName.startsWith(prefix) && fileName.endsWith(suffix) && fileName.length() > (prefix + suffix).length()) {
                filteredResourceNames.add(resourceName);
                continue;
            }
            LOG.debug((Object)("Filtering out resource: " + resourceName + " (filename: " + fileName + ")"));
        }
        return filteredResourceNames;
    }

    static {
        LOCATION_SCANNERS.add(new JarFileLocationScanner());
        LOCATION_SCANNERS.add(new FileSystemLocationScanner());
    }
}

