/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.compress;

import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.kryo.util.LongToIntHashMap;
import java.nio.ByteBuffer;

public class Delta {
    private static final boolean debug = false;
    private static final byte COMMAND_APPEND = -1;
    private static final byte COMMAND_COPY = 0;
    private static final int DATA_MAX = 253;
    private static final ByteBuffer emptyBuffer = ByteBuffer.allocate(0);
    private int chunkSize;
    private ByteBuffer tbuf;
    private ByteBuffer sbuf;
    private long hash;
    private boolean hashReset;
    private boolean eof;
    private final LongToIntHashMap checksums = new LongToIntHashMap();
    private ByteBuffer targetBuffer;
    private int appendLength;
    private int appendPosition;
    private static final char[] single_hash = new char[]{'\ubcd1', '\ubb65', '\u42c2', '\udffe', '\u9666', '\u431b', '\u8504', '\ueb46', '\u6379', '\ud460', '\ucf14', '\u53cf', '\udb51', '\udb08', '\u12c8', '\uf602', '\ue766', '\u2394', '\u250d', '\udcbb', '\ua678', '\u02af', '\ua5c6', '\u7ea6', '\ub645', '\ucb4d', '\uc44b', '\ue5dc', '\u9fe6', '\u5b5c', '\u35f5', '\u701a', '\u220f', '\u6c38', '\u1a56', '\u4ca3', '\uffc6', '\ub152', '\u8d61', '\u7a58', '\u9025', '\u8b3d', '\ubf0f', '\u95a3', '\ue5f4', '\uc127', '\u3bed', '\u320b', '\ub7f3', '\u6054', '\u333c', '\ud383', '\u8154', '\u5242', '\u4e0d', '\u0a94', '\u7028', '\u8689', '\u3a22', '\u0980', '\u1847', '\ub0f1', '\u9b5c', '\u4176', '\ub858', '\ud542', '\u1f6c', '\u2497', '\u6a5a', '\u9fa9', '\u8c5a', '\u7743', '\ua8a9', '\u9a02', '\u4918', '\u438c', '\uc388', '\u9e2b', '\u4cad', '\u01b6', '\uab19', '\uf777', '\u365f', '\u1eb2', '\u091e', '\u7bf8', '\u7a8e', '\u5227', '\ueab1', '\u2074', '\u4523', '\ue781', '\u01a3', '\u163d', '\u3b2e', '\u287d', '\u5e7f', '\ua063', '\ub134', '\u8fae', '\u5e8e', '\ub7b7', '\u4548', '\u1f5a', '\ufa56', '\u7a24', '\u900f', '\u42dc', '\ucc69', '\u02a0', '\u0b22', '\udb31', '\u71fe', '\u0c7d', '\u1732', '\u1159', '\ucb09', '\ue1d2', '\u1351', '\u52e9', '\uf536', '\u5a4f', '\uc316', '\u6bf9', '\u8994', '\ub774', '\u5f3e', '\uf6d6', '\u3a61', '\uf82c', '\ucc22', '\u9d06', '\u299c', '\u09e5', '\u1eec', '\u514f', '\u8d53', '\ua650', '\u5c6e', '\uc577', '\u7958', '\u71ac', '\u8916', '\u9b4f', '\u2c09', '\u5211', '\uf6d8', '\ucaaa', '\uf7ef', '\u287f', '\u7a94', '\uab49', '\ufa2c', '\u7222', '\ue457', '\ud71a', '\u00c3', '\u1a76', '\ue98c', '\uc037', '\u8208', '\u5c2d', '\udfda', '\ue5f5', '\u0b45', '\u15ce', '\u8a7e', '\ufcad', '\uaa2d', '\u4b5c', '\ud42e', '\ub251', '\u907e', '\u9a47', '\uc9a6', '\ud93f', '\u085e', '\u35ce', '\ua153', '\u7e7b', '\u9f0b', '\u25aa', '\u5d9f', '\uc04d', '\u8a0e', '\u2875', '\u4a1c', '\u295f', '\u1393', '\uf760', '\u9178', '\u0f5b', '\ufa7d', '\u83b4', '\u2082', '\u721d', '\u6462', '\u0368', '\u67e2', '\u8624', '\u194d', '\u22f6', '\u78fb', '\u6791', '\ub238', '\ub332', '\u7276', '\uf272', '\u47ec', '\u4504', '\ua961', '\u9fc8', '\u3fdc', '\ub413', 'z', '\u0806', '\u7458', '\u95c6', '\uccaa', '\u18d6', '\ue2ae', '\u1b06', '\uf3f6', '\u5050', '\uc8e8', '\uf4ac', '\uc04c', '\uf41c', '\u992f', '\uae44', '\u5f1b', '\u1113', '\u1738', '\ud9a8', '\u19ea', '\u2d33', '\u9698', '\u2fe9', '\u323f', '\ucde2', '\u6d71', '\ue37d', '\ub697', '\u2c4f', '\u4373', '\u9102', '\u075d', '\u8e25', '\u1672', '\uec28', '\u6acb', '\u86cc', '\u186e', '\u9414', '\ud674', '\ud1a5'};

    public Delta() {
        this(2048, 8);
    }

    public Delta(int bufferSize, int chunkSize) {
        this.chunkSize = chunkSize;
        int blockSize = Math.min(16384, chunkSize * 4);
        this.tbuf = ByteBuffer.allocate(blockSize);
        this.sbuf = ByteBuffer.allocate(blockSize);
    }

    public void compress(ByteBuffer sourceBuffer, ByteBuffer targetBuffer, ByteBuffer outputBuffer) {
        if (sourceBuffer == null) {
            sourceBuffer = emptyBuffer;
        }
        this.checksums.clear();
        this.eof = false;
        this.hashReset = true;
        this.tbuf.limit(0);
        this.targetBuffer = targetBuffer;
        int count = 0;
        while (sourceBuffer.remaining() >= this.chunkSize) {
            int high = 0;
            int low = 0;
            for (int i = 0; i < this.chunkSize; ++i) {
                high += (low += single_hash[sourceBuffer.get() + 128]);
            }
            long checksum = (high & 0xFFFF) << 16 | low & 0xFFFF;
            if (this.checksums.containsKey(checksum)) continue;
            this.checksums.put(checksum, count++);
        }
        while (!this.eof) {
            int index = this.find();
            if (index != -1) {
                int offset = index * this.chunkSize;
                sourceBuffer.position(offset);
                int length = this.longestMatch(sourceBuffer);
                if (length >= this.chunkSize) {
                    this.writeAppend(outputBuffer);
                    outputBuffer.put((byte)0);
                    IntSerializer.put(outputBuffer, length, true);
                    IntSerializer.put(outputBuffer, offset, true);
                    continue;
                }
                this.tbuf.position(this.tbuf.position() - length);
                this.appendData();
                continue;
            }
            this.appendData();
        }
        this.writeAppend(outputBuffer);
    }

    private void appendData() {
        int position = this.targetBuffer.position() - this.tbuf.remaining();
        if (this.tbuf.remaining() <= this.chunkSize && !this.readMore()) {
            return;
        }
        byte out = this.tbuf.get();
        if (this.tbuf.remaining() >= this.chunkSize) {
            byte in = this.tbuf.get(this.tbuf.position() + this.chunkSize - 1);
            char old_c = single_hash[out + 128];
            char new_c = single_hash[in + 128];
            int low = (int)(this.hash & 0xFFFFL) - old_c + new_c & 0xFFFF;
            int high = (int)(this.hash >> 16) - old_c * this.chunkSize + low & 0xFFFF;
            this.hash = high << 16 | low & 0xFFFF;
        }
        if (this.appendLength == 0) {
            this.appendPosition = position;
        }
        ++this.appendLength;
    }

    private void writeAppend(ByteBuffer outputBuffer) {
        if (this.appendLength == 0) {
            return;
        }
        int length = this.appendLength;
        if (length <= 253) {
            outputBuffer.put((byte)length);
        } else {
            outputBuffer.put((byte)-1);
            IntSerializer.put(outputBuffer, length, true);
        }
        int n = this.appendPosition + length;
        for (int i = this.appendPosition; i < n; ++i) {
            outputBuffer.put(this.targetBuffer.get(i));
        }
        this.appendLength = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int find() {
        this.sbuf.clear();
        this.sbuf.limit(0);
        if (this.hashReset) {
            while (this.tbuf.remaining() < this.chunkSize) {
                this.tbuf.compact();
                try {
                    if (!this.targetBuffer.hasRemaining()) {
                        int n = -1;
                        return n;
                    }
                    while (this.targetBuffer.hasRemaining() && this.tbuf.hasRemaining()) {
                        this.tbuf.put(this.targetBuffer.get());
                    }
                }
                finally {
                    this.tbuf.flip();
                }
            }
            this.tbuf.mark();
            int high = 0;
            int low = 0;
            for (int i = 0; i < this.chunkSize; ++i) {
                high += (low += single_hash[this.tbuf.get() + 128]);
            }
            this.hash = (high & 0xFFFF) << 16 | low & 0xFFFF;
            this.tbuf.reset();
            this.hashReset = false;
        }
        if (!this.checksums.containsKey(this.hash)) {
            return -1;
        }
        return this.checksums.get(this.hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int longestMatch(ByteBuffer sourceBuffer) {
        int match = 0;
        this.hashReset = true;
        while (true) {
            if (!this.sbuf.hasRemaining()) {
                this.sbuf.clear();
                try {
                    if (!sourceBuffer.hasRemaining()) {
                        int n = match;
                        return n;
                    }
                    while (sourceBuffer.hasRemaining() && this.sbuf.hasRemaining()) {
                        this.sbuf.put(sourceBuffer.get());
                    }
                }
                finally {
                    this.sbuf.flip();
                }
            }
            if (!this.tbuf.hasRemaining() && !this.readMore()) {
                return match;
            }
            if (this.sbuf.get() != this.tbuf.get()) {
                this.tbuf.position(this.tbuf.position() - 1);
                return match;
            }
            ++match;
        }
    }

    private boolean readMore() {
        this.tbuf.compact();
        while (this.targetBuffer.hasRemaining() && this.tbuf.hasRemaining()) {
            this.tbuf.put(this.targetBuffer.get());
        }
        this.tbuf.flip();
        if (!this.tbuf.hasRemaining()) {
            this.eof = true;
            return false;
        }
        return true;
    }

    public void decompress(ByteBuffer oldData, ByteBuffer deltaData, ByteBuffer outputBuffer) {
        block4: while (deltaData.remaining() > 0) {
            int length;
            int command = deltaData.get();
            if (command > 0 && command <= 253) {
                length = command;
                command = -1;
            } else {
                length = IntSerializer.get(deltaData, true);
            }
            switch (command) {
                case -1: {
                    while (length-- > 0) {
                        outputBuffer.put(deltaData.get());
                    }
                    continue block4;
                }
                case 0: {
                    if (oldData == null) {
                        throw new SerializationException("Delta copy command received without previous data.");
                    }
                    int offset = IntSerializer.get(deltaData, true);
                    oldData.position(offset);
                    while (length-- > 0) {
                        outputBuffer.put(oldData.get());
                    }
                    continue block4;
                }
            }
            throw new SerializationException("Invalid delta command: " + command);
        }
    }

    private static StringBuilder dump(ByteBuffer buffer, int position, int length) {
        int oldPosition = buffer.position();
        buffer.position(position);
        StringBuilder stringBuffer = new StringBuilder();
        while (length-- > 0) {
            stringBuffer.append(buffer.get());
            stringBuffer.append(',');
        }
        buffer.position(oldPosition);
        return stringBuffer;
    }
}

