/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.cucumber.companion.generator;

import java.nio.file.Path;
import java.util.Optional;
import java.util.Spliterators;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class CompanionFile {
    private static final Pattern VALID_PACKAGE_ELEMENTS = Pattern.compile("[^a-zA-Z0-9_$]");
    private static final Pattern VALID_CLASS_NAME = Pattern.compile("[^a-zA-Z0-9_]");
    private final Path actual;
    private final Path relativeSrc;
    private final Path destination;
    private final String featureName;
    private final Optional<String> packageName;

    public CompanionFile(Path sourceDir, Path destinationDir, Path actual) {
        this(sourceDir, destinationDir, actual, "");
    }

    public CompanionFile(Path sourceDir, Path destinationDir, Path actual, String suffix) {
        if (!actual.getFileName().toString().endsWith(".feature")) {
            throw new IllegalArgumentException("The passed parameter was not a feature file:" + actual);
        }
        this.actual = actual;
        this.relativeSrc = sourceDir.relativize(actual);
        this.featureName = this.toValidClassName(CompanionFile.getNameWithoutExtension(actual)) + suffix;
        Path relativeDest = this.relativeSrc.resolveSibling(this.featureName + ".java");
        this.destination = destinationDir.resolve(relativeDest);
        this.packageName = this.relativeSrc.getParent() == null ? Optional.empty() : Optional.of(this.toPackageList(this.relativeSrc.getParent()));
    }

    private String toValidClassName(String nameWithoutExtension) {
        return VALID_CLASS_NAME.matcher(nameWithoutExtension).replaceAll("_");
    }

    private String toPackageList(Path parent) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(parent.iterator(), 16), false).map(Path::toString).map(VALID_PACKAGE_ELEMENTS::matcher).map(m -> m.replaceAll("_")).collect(Collectors.joining("."));
    }

    private static String getNameWithoutExtension(Path path) {
        String originalFileName = path.getFileName().toString();
        return originalFileName.substring(0, originalFileName.lastIndexOf(46));
    }

    public Path getSource() {
        return this.actual;
    }

    public Path getDestination() {
        return this.destination;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getClassPathResource() {
        return this.relativeSrc.toString();
    }

    public Optional<String> getPackageName() {
        return this.packageName;
    }

    public String toString() {
        return "CompanionFile{src=" + this.actual + ", dest=" + this.destination + "}";
    }
}

