/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.cucumber.companion.generator;

import com.gradle.cucumber.companion.generator.CompanionFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class CompanionGenerator {
    private static final String NEW_LINE = "\n";

    public static CompanionFile resolve(Path sourceDir, Path targetDir, Path actual) {
        return new CompanionFile(sourceDir, targetDir, actual);
    }

    public static void create(CompanionFile companionFile) throws IOException {
        CompanionGenerator.ensureParentDirectoryExists(companionFile.getDestination());
        try (BufferedWriter bw = Files.newBufferedWriter(companionFile.getDestination(), StandardCharsets.UTF_8, new OpenOption[0]);){
            if (companionFile.getPackageName().isPresent()) {
                bw.write("package ");
                bw.write(companionFile.getPackageName().get());
                bw.write(";");
                bw.write(NEW_LINE);
                bw.write(NEW_LINE);
            }
            bw.write("@org.junit.platform.suite.api.Suite");
            bw.write(NEW_LINE);
            bw.write("@org.junit.platform.suite.api.SelectClasspathResource(\"");
            bw.write(companionFile.getClassPathResource().replace('\\', '/'));
            bw.write("\")");
            bw.write(NEW_LINE);
            bw.write("class ");
            bw.write(companionFile.getFeatureName());
            bw.write(" {");
            bw.write(NEW_LINE);
            bw.write("    public static final String CONTENT_HASH = \"");
            bw.write(CompanionGenerator.generateFileHash(companionFile.getSource()));
            bw.write("\";");
            bw.write(NEW_LINE);
            bw.write("}");
            bw.write(NEW_LINE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void ensureParentDirectoryExists(Path destination) throws IOException {
        Files.createDirectories(destination.getParent(), new FileAttribute[0]);
    }

    private static String generateFileHash(Path actual) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] buffer = new byte[8192];
            try (InputStream fis = Files.newInputStream(actual, new OpenOption[0]);){
                int bytesRead;
                while ((bytesRead = fis.read(buffer)) != -1) {
                    md.update(buffer, 0, bytesRead);
                }
            }
            byte[] hash = md.digest();
            return Base64.getUrlEncoder().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            return "<No SHA-256 algorithm available>";
        }
        catch (IOException e) {
            return "<Could not read source file>";
        }
    }
}

