/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util;

import java.io.Serializable;

public class Separators
implements Serializable {
    private final char objectFieldValueSeparator;
    private final Spacing objectFieldValueSpacing;
    private final char objectEntrySeparator;
    private final Spacing objectEntrySpacing;
    private final char arrayValueSeparator;
    private final Spacing arrayValueSpacing;
    private final String rootSeparator;

    public static Separators createDefaultInstance() {
        return new Separators();
    }

    public Separators() {
        this(':', ',', ',');
    }

    public Separators(char c2, char c3, char c4) {
        this(" ", c2, Spacing.BOTH, c3, Spacing.NONE, c4, Spacing.NONE);
    }

    public Separators(String string, char c2, Spacing spacing, char c3, Spacing spacing2, char c4, Spacing spacing3) {
        this.rootSeparator = string;
        this.objectFieldValueSeparator = c2;
        this.objectFieldValueSpacing = spacing;
        this.objectEntrySeparator = c3;
        this.objectEntrySpacing = spacing2;
        this.arrayValueSeparator = c4;
        this.arrayValueSpacing = spacing3;
    }

    public Separators withObjectFieldValueSpacing(Spacing spacing) {
        return this.objectFieldValueSpacing == spacing ? this : new Separators(this.rootSeparator, this.objectFieldValueSeparator, spacing, this.objectEntrySeparator, this.objectEntrySpacing, this.arrayValueSeparator, this.arrayValueSpacing);
    }

    public String getRootSeparator() {
        return this.rootSeparator;
    }

    public char getObjectFieldValueSeparator() {
        return this.objectFieldValueSeparator;
    }

    public Spacing getObjectFieldValueSpacing() {
        return this.objectFieldValueSpacing;
    }

    public char getObjectEntrySeparator() {
        return this.objectEntrySeparator;
    }

    public Spacing getObjectEntrySpacing() {
        return this.objectEntrySpacing;
    }

    public char getArrayValueSeparator() {
        return this.arrayValueSeparator;
    }

    public Spacing getArrayValueSpacing() {
        return this.arrayValueSpacing;
    }

    public static enum Spacing {
        NONE("", ""),
        BEFORE(" ", ""),
        AFTER("", " "),
        BOTH(" ", " ");

        private final String spacesBefore;
        private final String spacesAfter;

        private Spacing(String string2, String string3) {
            this.spacesBefore = string2;
            this.spacesAfter = string3;
        }

        public String apply(char c2) {
            return this.spacesBefore + c2 + this.spacesAfter;
        }
    }
}

