/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec;

import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.Headers;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class HeadersUtils {
    public static <K, V> List<String> getAllAsString(Headers<K, V, ?> headers, K k2) {
        final List<V> list = headers.getAll(k2);
        return new AbstractList<String>(){

            @Override
            public String get(int n2) {
                Object e2 = list.get(n2);
                return e2 != null ? e2.toString() : null;
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static <K, V> String getAsString(Headers<K, V, ?> headers, K k2) {
        V v2 = headers.get(k2);
        return v2 != null ? v2.toString() : null;
    }

    public static Iterator<Map.Entry<String, String>> iteratorAsString(Iterable<Map.Entry<CharSequence, CharSequence>> iterable) {
        return new StringEntryIterator(iterable.iterator());
    }

    public static <K, V> String toString(Class<?> clazz, Iterator<Map.Entry<K, V>> iterator, int n2) {
        String string = clazz.getSimpleName();
        if (n2 == 0) {
            return string + "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2 + n2 * 20).append(string).append('[');
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            stringBuilder.append(entry.getKey()).append(": ").append(entry.getValue()).append(", ");
        }
        stringBuilder.setLength(stringBuilder.length() - 2);
        return stringBuilder.append(']').toString();
    }

    private static final class StringEntry
    implements Map.Entry<String, String> {
        private final Map.Entry<CharSequence, CharSequence> entry;
        private String name;
        private String value;

        StringEntry(Map.Entry<CharSequence, CharSequence> entry) {
            this.entry = entry;
        }

        @Override
        public String getKey() {
            if (this.name == null) {
                this.name = this.entry.getKey().toString();
            }
            return this.name;
        }

        @Override
        public String getValue() {
            if (this.value == null && this.entry.getValue() != null) {
                this.value = this.entry.getValue().toString();
            }
            return this.value;
        }

        @Override
        public String setValue(String string) {
            String string2 = this.getValue();
            this.entry.setValue(string);
            return string2;
        }

        public String toString() {
            return this.entry.toString();
        }
    }

    private static final class StringEntryIterator
    implements Iterator<Map.Entry<String, String>> {
        private final Iterator<Map.Entry<CharSequence, CharSequence>> iter;

        StringEntryIterator(Iterator<Map.Entry<CharSequence, CharSequence>> iterator) {
            this.iter = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Map.Entry<String, String> next() {
            return new StringEntry(this.iter.next());
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

