/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.commons.io;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.io.StandardLineSeparator;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.io.function.IOConsumer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class IOUtils {
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    @Deprecated
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String LINE_SEPARATOR_UNIX = StandardLineSeparator.LF.getString();
    public static final String LINE_SEPARATOR_WINDOWS = StandardLineSeparator.CRLF.getString();
    private static final ThreadLocal<byte[]> SCRATCH_BYTE_BUFFER_RW = ThreadLocal.withInitial(IOUtils::byteArray);
    private static final byte[] SCRATCH_BYTE_BUFFER_WO = IOUtils.byteArray();
    private static final ThreadLocal<char[]> SCRATCH_CHAR_BUFFER_RW = ThreadLocal.withInitial(IOUtils::charArray);
    private static final char[] SCRATCH_CHAR_BUFFER_WO = IOUtils.charArray();

    public static byte[] byteArray() {
        return IOUtils.byteArray(8192);
    }

    public static byte[] byteArray(int n2) {
        return new byte[n2];
    }

    private static char[] charArray() {
        return IOUtils.charArray(8192);
    }

    private static char[] charArray(int n2) {
        return new char[n2];
    }

    public static void close(Closeable closeable, IOConsumer<IOException> iOConsumer) throws IOException {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    if (iOConsumer == null) break block3;
                    iOConsumer.accept(iOException);
                }
            }
        }
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int n2) throws IOException {
        return IOUtils.copyLarge(inputStream, outputStream, IOUtils.byteArray(n2));
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n2;
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(outputStream, "outputStream");
        long l2 = 0L;
        while (-1 != (n2 = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static int length(byte[] byArray) {
        return byArray == null ? 0 : byArray.length;
    }
}

