/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.protocol;

import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpRequest;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpRequestInterceptor;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpResponse;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpResponseInterceptor;
import com.gradle.scan.plugin.internal.dep.org.apache.http.protocol.HttpContext;
import com.gradle.scan.plugin.internal.dep.org.apache.http.protocol.HttpProcessor;
import java.io.IOException;
import java.util.List;

public final class ImmutableHttpProcessor
implements HttpProcessor {
    private final HttpRequestInterceptor[] requestInterceptors;
    private final HttpResponseInterceptor[] responseInterceptors;

    public ImmutableHttpProcessor(HttpRequestInterceptor[] httpRequestInterceptorArray, HttpResponseInterceptor[] httpResponseInterceptorArray) {
        int n2;
        if (httpRequestInterceptorArray != null) {
            n2 = httpRequestInterceptorArray.length;
            this.requestInterceptors = new HttpRequestInterceptor[n2];
            System.arraycopy(httpRequestInterceptorArray, 0, this.requestInterceptors, 0, n2);
        } else {
            this.requestInterceptors = new HttpRequestInterceptor[0];
        }
        if (httpResponseInterceptorArray != null) {
            n2 = httpResponseInterceptorArray.length;
            this.responseInterceptors = new HttpResponseInterceptor[n2];
            System.arraycopy(httpResponseInterceptorArray, 0, this.responseInterceptors, 0, n2);
        } else {
            this.responseInterceptors = new HttpResponseInterceptor[0];
        }
    }

    public ImmutableHttpProcessor(List<HttpRequestInterceptor> list, List<HttpResponseInterceptor> list2) {
        int n2;
        if (list != null) {
            n2 = list.size();
            this.requestInterceptors = list.toArray(new HttpRequestInterceptor[n2]);
        } else {
            this.requestInterceptors = new HttpRequestInterceptor[0];
        }
        if (list2 != null) {
            n2 = list2.size();
            this.responseInterceptors = list2.toArray(new HttpResponseInterceptor[n2]);
        } else {
            this.responseInterceptors = new HttpResponseInterceptor[0];
        }
    }

    public ImmutableHttpProcessor(HttpRequestInterceptor ... httpRequestInterceptorArray) {
        this(httpRequestInterceptorArray, (HttpResponseInterceptor[])null);
    }

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws IOException, HttpException {
        for (HttpRequestInterceptor httpRequestInterceptor : this.requestInterceptors) {
            httpRequestInterceptor.process(httpRequest, httpContext);
        }
    }

    @Override
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws IOException, HttpException {
        for (HttpResponseInterceptor httpResponseInterceptor : this.responseInterceptors) {
            httpResponseInterceptor.process(httpResponse, httpContext);
        }
    }
}

