/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.kryo5.util;

public class IntArray {
    public int[] items;
    public int size;
    public boolean ordered;

    public IntArray() {
        this(true, 16);
    }

    public IntArray(int n2) {
        this(true, n2);
    }

    public IntArray(boolean bl2, int n2) {
        this.ordered = bl2;
        this.items = new int[n2];
    }

    public void add(int n2) {
        int[] nArray = this.items;
        if (this.size == nArray.length) {
            nArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        nArray[this.size++] = n2;
    }

    public void incr(int n2, int n3) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n2 + " >= " + this.size);
        }
        int n4 = n2;
        this.items[n4] = this.items[n4] + n3;
    }

    public int pop() {
        return this.items[--this.size];
    }

    public int peek() {
        return this.items[this.size - 1];
    }

    protected int[] resize(int n2) {
        int[] nArray = new int[n2];
        int[] nArray2 = this.items;
        System.arraycopy(nArray2, 0, nArray, 0, Math.min(this.size, nArray.length));
        this.items = nArray;
        return nArray;
    }

    public int[] toArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.items, 0, nArray, 0, this.size);
        return nArray;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        int[] nArray = this.items;
        int n2 = 1;
        int n3 = this.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = n2 * 31 + nArray[i2];
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof IntArray)) {
            return false;
        }
        IntArray intArray = (IntArray)object;
        if (!intArray.ordered) {
            return false;
        }
        int n2 = this.size;
        if (n2 != intArray.size) {
            return false;
        }
        int[] nArray = this.items;
        int[] nArray2 = intArray.items;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] == nArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        int[] nArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(nArray[0]);
        for (int i2 = 1; i2 < this.size; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(nArray[i2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

