/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.time.DateTimeException;
import java.util.Arrays;

abstract class JSR310DeserializerBase<T>
extends StdScalarDeserializer<T> {
    protected final boolean _isLenient;

    protected JSR310DeserializerBase(Class<T> clazz) {
        super(clazz);
        this._isLenient = true;
    }

    protected JSR310DeserializerBase(Class<T> clazz, Boolean bl2) {
        super(clazz);
        this._isLenient = !Boolean.FALSE.equals(bl2);
    }

    protected JSR310DeserializerBase(JSR310DeserializerBase<T> jSR310DeserializerBase) {
        super((StdScalarDeserializer<?>)jSR310DeserializerBase);
        this._isLenient = jSR310DeserializerBase._isLenient;
    }

    protected JSR310DeserializerBase(JSR310DeserializerBase<T> jSR310DeserializerBase, Boolean bl2) {
        super((StdScalarDeserializer<?>)jSR310DeserializerBase);
        this._isLenient = !Boolean.FALSE.equals(bl2);
    }

    protected boolean isLenient() {
        return this._isLenient;
    }

    protected T _fromEmptyString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
        switch (coercionAction) {
            case AsEmpty: {
                return (T)this.getEmptyValue(deserializationContext);
            }
        }
        if (!this._isLenient) {
            return this._failForNotLenient(jsonParser, deserializationContext, JsonToken.VALUE_STRING);
        }
        return null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.DateTime;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    protected boolean _isValidTimestampString(String string) {
        return this._isIntNumber(string) && NumberInput.inLongRange(string, string.charAt(0) == '-');
    }

    protected <BOGUS> BOGUS _reportWrongToken(DeserializationContext deserializationContext, JsonToken jsonToken, String string) throws IOException {
        deserializationContext.reportWrongTokenException(this, jsonToken, "Expected %s for '%s' of %s value", jsonToken.name(), string, this.handledType().getName());
        return null;
    }

    protected <R> R _handleDateTimeException(DeserializationContext deserializationContext, DateTimeException dateTimeException, String string) throws JsonMappingException {
        try {
            return (R)deserializationContext.handleWeirdStringValue(this.handledType(), string, "Failed to deserialize %s: (%s) %s", this.handledType().getName(), dateTimeException.getClass().getName(), dateTimeException.getMessage());
        }
        catch (JsonMappingException jsonMappingException) {
            jsonMappingException.initCause(dateTimeException);
            throw jsonMappingException;
        }
        catch (IOException iOException) {
            if (null == iOException.getCause()) {
                iOException.initCause(dateTimeException);
            }
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
    }

    protected <R> R _handleUnexpectedToken(DeserializationContext deserializationContext, JsonParser jsonParser, String string, Object ... objectArray) throws JsonMappingException {
        try {
            return (R)deserializationContext.handleUnexpectedToken(this.handledType(), jsonParser.getCurrentToken(), jsonParser, string, objectArray);
        }
        catch (JsonMappingException jsonMappingException) {
            throw jsonMappingException;
        }
        catch (IOException iOException) {
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
    }

    protected <R> R _handleUnexpectedToken(DeserializationContext deserializationContext, JsonParser jsonParser, JsonToken ... jsonTokenArray) throws JsonMappingException {
        return this._handleUnexpectedToken(deserializationContext, jsonParser, "Unexpected token (%s), expected one of %s for %s value", new Object[]{jsonParser.currentToken(), Arrays.asList(jsonTokenArray), this.handledType().getName()});
    }

    protected T _failForNotLenient(JsonParser jsonParser, DeserializationContext deserializationContext, JsonToken jsonToken) throws IOException {
        return (T)deserializationContext.handleUnexpectedToken(this.handledType(), jsonToken, jsonParser, "Cannot deserialize instance of %s out of %s token: not allowed because 'strict' mode set for property or type (enable 'lenient' handling to allow)", new Object[]{ClassUtil.nameOf(this.handledType()), jsonParser.currentToken()});
    }
}

