/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core;

import java.io.Serializable;
import java.util.Objects;

public class Version
implements Serializable,
Comparable<Version> {
    private static final Version UNKNOWN_VERSION = new Version(0, 0, 0, null, null, null);
    protected final int _majorVersion;
    protected final int _minorVersion;
    protected final int _patchLevel;
    protected final String _groupId;
    protected final String _artifactId;
    protected final String _snapshotInfo;

    public Version(int n2, int n3, int n4, String string, String string2, String string3) {
        this._majorVersion = n2;
        this._minorVersion = n3;
        this._patchLevel = n4;
        this._snapshotInfo = string;
        this._groupId = string2 == null ? "" : string2;
        this._artifactId = string3 == null ? "" : string3;
    }

    public static Version unknownVersion() {
        return UNKNOWN_VERSION;
    }

    public boolean isSnapshot() {
        return this._snapshotInfo != null && this._snapshotInfo.length() > 0;
    }

    public String getArtifactId() {
        return this._artifactId;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._majorVersion).append('.');
        stringBuilder.append(this._minorVersion).append('.');
        stringBuilder.append(this._patchLevel);
        if (this.isSnapshot()) {
            stringBuilder.append('-').append(this._snapshotInfo);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this._artifactId.hashCode() ^ this._groupId.hashCode() ^ Objects.hashCode(this._snapshotInfo) + this._majorVersion - this._minorVersion + this._patchLevel;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Version version = (Version)object;
        return version._majorVersion == this._majorVersion && version._minorVersion == this._minorVersion && version._patchLevel == this._patchLevel && Objects.equals(version._snapshotInfo, this._snapshotInfo) && version._artifactId.equals(this._artifactId) && version._groupId.equals(this._groupId);
    }

    @Override
    public int compareTo(Version version) {
        if (version == this) {
            return 0;
        }
        int n2 = this._groupId.compareTo(version._groupId);
        if (n2 == 0 && (n2 = this._artifactId.compareTo(version._artifactId)) == 0 && (n2 = this._majorVersion - version._majorVersion) == 0 && (n2 = this._minorVersion - version._minorVersion) == 0 && (n2 = this._patchLevel - version._patchLevel) == 0) {
            n2 = this.isSnapshot() ? (version.isSnapshot() ? this._snapshotInfo.compareTo(version._snapshotInfo) : -1) : (version.isSnapshot() ? 1 : 0);
        }
        return n2;
    }
}

