/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.unix.solaris;

import com.gradle.scan.plugin.internal.dep.oshi.hardware.CentralProcessor;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.common.AbstractCentralProcessor;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.unix.solaris.SolarisOperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.platform.unix.solaris.KstatUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.tuples.Quartet;
import com.sun.jna.platform.unix.solaris.LibKstat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SolarisCentralProcessor
extends AbstractCentralProcessor {
    SolarisCentralProcessor() {
    }

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        boolean bl2 = "64".equals(ExecutingCommand.getFirstAnswer("isainfo -b").trim());
        if (SolarisOperatingSystem.HAS_KSTAT2) {
            return SolarisCentralProcessor.queryProcessorId2(bl2);
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        long l2 = 0L;
        try (Object object = KstatUtil.openChain();){
            LibKstat.Kstat kstat = ((KstatUtil.KstatChain)object).lookup("cpu_info", -1, null);
            if (kstat != null && ((KstatUtil.KstatChain)object).read(kstat)) {
                string = KstatUtil.dataLookupString(kstat, "vendor_id");
                string2 = KstatUtil.dataLookupString(kstat, "brand");
                string3 = KstatUtil.dataLookupString(kstat, "family");
                string4 = KstatUtil.dataLookupString(kstat, "model");
                string5 = KstatUtil.dataLookupString(kstat, "stepping");
                l2 = KstatUtil.dataLookupLong(kstat, "clock_MHz") * 1000000L;
            }
        }
        object = SolarisCentralProcessor.getProcessorID(string5, string4, string3);
        return new CentralProcessor.ProcessorIdentifier(string, string2, string3, string4, string5, (String)object, bl2, l2);
    }

    private static CentralProcessor.ProcessorIdentifier queryProcessorId2(boolean bl2) {
        Object[] objectArray = KstatUtil.queryKstat2("kstat:/system/cpu/0/info", "vendor_id", "brand", "family", "model", "stepping", "clock_MHz");
        String string = objectArray[0] == null ? "" : (String)objectArray[0];
        String string2 = objectArray[1] == null ? "" : (String)objectArray[1];
        String string3 = objectArray[2] == null ? "" : objectArray[2].toString();
        String string4 = objectArray[3] == null ? "" : objectArray[3].toString();
        String string5 = objectArray[4] == null ? "" : objectArray[4].toString();
        long l2 = objectArray[5] == null ? 0L : (Long)objectArray[5];
        String string6 = SolarisCentralProcessor.getProcessorID(string5, string4, string3);
        return new CentralProcessor.ProcessorIdentifier(string, string2, string3, string4, string5, string6, bl2, l2);
    }

    @Override
    protected Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>, List<String>> initProcessorCounts() {
        Object object;
        Object object2;
        Object object3;
        List<CentralProcessor.LogicalProcessor> list;
        Map<Integer, Integer> map = SolarisCentralProcessor.mapNumaNodes();
        if (SolarisOperatingSystem.HAS_KSTAT2) {
            list = SolarisCentralProcessor.initProcessorCounts2(map);
        } else {
            list = new ArrayList<CentralProcessor.LogicalProcessor>();
            object3 = KstatUtil.openChain();
            try {
                object2 = ((KstatUtil.KstatChain)object3).lookupAll("cpu_info", -1, null);
                object = object2.iterator();
                while (object.hasNext()) {
                    LibKstat.Kstat object4 = (LibKstat.Kstat)object.next();
                    if (object4 == null || !((KstatUtil.KstatChain)object3).read(object4)) continue;
                    int n2 = list.size();
                    String string = KstatUtil.dataLookupString(object4, "chip_id");
                    String string2 = KstatUtil.dataLookupString(object4, "core_id");
                    CentralProcessor.LogicalProcessor logicalProcessor = new CentralProcessor.LogicalProcessor(n2, ParseUtil.parseIntOrDefault(string2, 0), ParseUtil.parseIntOrDefault(string, 0), map.getOrDefault(n2, 0));
                    list.add(logicalProcessor);
                }
            }
            finally {
                if (object3 != null) {
                    ((KstatUtil.KstatChain)object3).close();
                }
            }
        }
        if (list.isEmpty()) {
            list.add(new CentralProcessor.LogicalProcessor(0, 0, 0));
        }
        object3 = new HashMap();
        object2 = Pattern.compile(".* cpu(\\\\d+): ((ARM|AMD|Intel).+)");
        for (String string : ExecutingCommand.runNative("dmesg")) {
            Matcher matcher = ((Pattern)object2).matcher(string);
            if (!matcher.matches()) continue;
            int n3 = ParseUtil.parseIntOrDefault(matcher.group(1), 0);
            object3.put(n3, matcher.group(2).trim());
        }
        if (object3.isEmpty()) {
            return new Quartet(list, null, null, Collections.emptyList());
        }
        object = ExecutingCommand.runNative("isainfo -x");
        return new Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, Object, Object>(list, this.createProcListFromDmesg(list, (Map<Integer, String>)object3), null, object);
    }

    private static List<CentralProcessor.LogicalProcessor> initProcessorCounts2(Map<Integer, Integer> map) {
        ArrayList<CentralProcessor.LogicalProcessor> arrayList = new ArrayList<CentralProcessor.LogicalProcessor>();
        List<Object[]> list = KstatUtil.queryKstat2List("kstat:/system/cpu/", "/info", "chip_id", "core_id");
        for (Object[] objectArray : list) {
            int n2 = arrayList.size();
            long l2 = objectArray[0] == null ? 0L : (Long)objectArray[0];
            long l3 = objectArray[1] == null ? 0L : (Long)objectArray[1];
            CentralProcessor.LogicalProcessor logicalProcessor = new CentralProcessor.LogicalProcessor(n2, (int)l3, (int)l2, map.getOrDefault(n2, 0));
            arrayList.add(logicalProcessor);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(new CentralProcessor.LogicalProcessor(0, 0, 0));
        }
        return arrayList;
    }

    private static Map<Integer, Integer> mapNumaNodes() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n2 = 0;
        for (String string : ExecutingCommand.runNative("lgrpinfo -c leaves")) {
            if (string.startsWith("lgroup")) {
                n2 = ParseUtil.getFirstIntValue(string);
                continue;
            }
            if (!string.contains("CPUs:") && !string.contains("CPU:")) continue;
            for (Integer n3 : ParseUtil.parseHyphenatedIntList(string.split(":")[1])) {
                hashMap.put(n3, n2);
            }
        }
        return hashMap;
    }

    @Override
    public long[] querySystemCpuLoadTicks() {
        long[] lArray = new long[CentralProcessor.TickType.values().length];
        long[][] lArray2 = this.getProcessorCpuLoadTicks();
        int n2 = 0;
        while (n2 < lArray.length) {
            for (long[] lArray3 : lArray2) {
                int n3 = n2;
                lArray[n3] = lArray[n3] + lArray3[n2];
            }
            int n4 = n2++;
            lArray[n4] = lArray[n4] / (long)lArray2.length;
        }
        return lArray;
    }

    @Override
    public long[] queryCurrentFreq() {
        if (SolarisOperatingSystem.HAS_KSTAT2) {
            return SolarisCentralProcessor.queryCurrentFreq2(this.getLogicalProcessorCount());
        }
        long[] lArray = new long[this.getLogicalProcessorCount()];
        Arrays.fill(lArray, -1L);
        try (KstatUtil.KstatChain kstatChain = KstatUtil.openChain();){
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                for (LibKstat.Kstat kstat : kstatChain.lookupAll("cpu_info", i2, null)) {
                    if (kstat == null || !kstatChain.read(kstat)) continue;
                    lArray[i2] = KstatUtil.dataLookupLong(kstat, "current_clock_Hz");
                }
            }
        }
        return lArray;
    }

    private static long[] queryCurrentFreq2(int n2) {
        long[] lArray = new long[n2];
        Arrays.fill(lArray, -1L);
        List<Object[]> list = KstatUtil.queryKstat2List("kstat:/system/cpu/", "/info", "current_clock_Hz");
        int n3 = -1;
        for (Object[] objectArray : list) {
            if (++n3 >= lArray.length) break;
            lArray[n3] = objectArray[0] == null ? -1L : (Long)objectArray[0];
        }
        return lArray;
    }

    @Override
    public long queryMaxFreq() {
        if (SolarisOperatingSystem.HAS_KSTAT2) {
            return SolarisCentralProcessor.queryMaxFreq2();
        }
        long l2 = -1L;
        try (KstatUtil.KstatChain kstatChain = KstatUtil.openChain();){
            for (LibKstat.Kstat kstat : kstatChain.lookupAll("cpu_info", 0, null)) {
                String string;
                if (!kstatChain.read(kstat) || (string = KstatUtil.dataLookupString(kstat, "supported_frequencies_Hz")).isEmpty()) continue;
                for (String string2 : string.split(":")) {
                    long l3 = ParseUtil.parseLongOrDefault(string2, -1L);
                    if (l2 >= l3) continue;
                    l2 = l3;
                }
            }
        }
        return l2;
    }

    private static long queryMaxFreq2() {
        long l2 = -1L;
        List<Object[]> list = KstatUtil.queryKstat2List("kstat:/pm/cpu/", "/pstate", "supported_frequencies");
        for (Object[] objectArray : list) {
            for (long l3 : objectArray[0] == null ? new long[]{} : (long[])objectArray[0]) {
                if (l3 <= l2) continue;
                l2 = l3;
            }
        }
        return l2;
    }

    @Override
    public long[][] queryProcessorCpuLoadTicks() {
        if (SolarisOperatingSystem.HAS_KSTAT2) {
            return SolarisCentralProcessor.queryProcessorCpuLoadTicks2(this.getLogicalProcessorCount());
        }
        long[][] lArray = new long[this.getLogicalProcessorCount()][CentralProcessor.TickType.values().length];
        int n2 = -1;
        try (KstatUtil.KstatChain kstatChain = KstatUtil.openChain();){
            for (LibKstat.Kstat kstat : kstatChain.lookupAll("cpu", -1, "sys")) {
                if (++n2 >= lArray.length) {
                    break;
                }
                if (!kstatChain.read(kstat)) continue;
                lArray[n2][CentralProcessor.TickType.IDLE.getIndex()] = KstatUtil.dataLookupLong(kstat, "cpu_ticks_idle");
                lArray[n2][CentralProcessor.TickType.SYSTEM.getIndex()] = KstatUtil.dataLookupLong(kstat, "cpu_ticks_kernel");
                lArray[n2][CentralProcessor.TickType.USER.getIndex()] = KstatUtil.dataLookupLong(kstat, "cpu_ticks_user");
            }
        }
        return lArray;
    }

    private static long[][] queryProcessorCpuLoadTicks2(int n2) {
        long[][] lArray = new long[n2][CentralProcessor.TickType.values().length];
        List<Object[]> list = KstatUtil.queryKstat2List("kstat:/system/cpu/", "/sys", "cpu_ticks_idle", "cpu_ticks_kernel", "cpu_ticks_user");
        int n3 = -1;
        for (Object[] objectArray : list) {
            if (++n3 >= lArray.length) break;
            lArray[n3][CentralProcessor.TickType.IDLE.getIndex()] = objectArray[0] == null ? 0L : (Long)objectArray[0];
            lArray[n3][CentralProcessor.TickType.SYSTEM.getIndex()] = objectArray[1] == null ? 0L : (Long)objectArray[1];
            lArray[n3][CentralProcessor.TickType.USER.getIndex()] = objectArray[2] == null ? 0L : (Long)objectArray[2];
        }
        return lArray;
    }

    private static String getProcessorID(String string, String string2, String string3) {
        List<String> list = ExecutingCommand.runNative("isainfo -v");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string4 : list) {
            if (string4.startsWith("32-bit")) break;
            if (string4.startsWith("64-bit")) continue;
            stringBuilder.append(' ').append(string4.trim());
        }
        return SolarisCentralProcessor.createProcessorID(string, string2, string3, ParseUtil.whitespaces.split(stringBuilder.toString().toLowerCase(Locale.ROOT)));
    }

    @Override
    public long queryContextSwitches() {
        if (SolarisOperatingSystem.HAS_KSTAT2) {
            return SolarisCentralProcessor.queryContextSwitches2();
        }
        long l2 = 0L;
        List<String> list = ExecutingCommand.runNative("kstat -p cpu_stat:::/pswitch\\\\|inv_swtch/");
        for (String string : list) {
            l2 += ParseUtil.parseLastLong(string, 0L);
        }
        return l2;
    }

    private static long queryContextSwitches2() {
        long l2 = 0L;
        List<Object[]> list = KstatUtil.queryKstat2List("kstat:/system/cpu/", "/sys", "pswitch", "inv_swtch");
        for (Object[] objectArray : list) {
            l2 += objectArray[0] == null ? 0L : (Long)objectArray[0];
            l2 += objectArray[1] == null ? 0L : (Long)objectArray[1];
        }
        return l2;
    }

    @Override
    public long queryInterrupts() {
        if (SolarisOperatingSystem.HAS_KSTAT2) {
            return SolarisCentralProcessor.queryInterrupts2();
        }
        long l2 = 0L;
        List<String> list = ExecutingCommand.runNative("kstat -p cpu_stat:::/intr/");
        for (String string : list) {
            l2 += ParseUtil.parseLastLong(string, 0L);
        }
        return l2;
    }

    private static long queryInterrupts2() {
        long l2 = 0L;
        List<Object[]> list = KstatUtil.queryKstat2List("kstat:/system/cpu/", "/sys", "intr");
        for (Object[] objectArray : list) {
            l2 += objectArray[0] == null ? 0L : (Long)objectArray[0];
        }
        return l2;
    }
}

