/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.io;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import java.io.IOException;
import java.io.Reader;

public final class MergedReader
extends Reader {
    final ReaderConfig mConfig;
    final Reader mIn;
    char[] mData;
    int mPtr;
    final int mEnd;

    public MergedReader(ReaderConfig readerConfig, Reader reader, char[] cArray, int n2, int n3) {
        this.mConfig = readerConfig;
        this.mIn = reader;
        this.mData = cArray;
        this.mPtr = n2;
        this.mEnd = n3;
        if (cArray != null && n2 >= n3) {
            throw new IllegalArgumentException("Trying to construct MergedReader with empty contents (start " + n2 + ", end " + n3 + ")");
        }
    }

    @Override
    public void close() throws IOException {
        this.freeMergedBuffer();
        this.mIn.close();
    }

    @Override
    public void mark(int n2) throws IOException {
        if (this.mData == null) {
            this.mIn.mark(n2);
        }
    }

    @Override
    public boolean markSupported() {
        return this.mData == null && this.mIn.markSupported();
    }

    @Override
    public int read() throws IOException {
        if (this.mData != null) {
            int n2 = this.mData[this.mPtr++] & 0xFF;
            if (this.mPtr >= this.mEnd) {
                this.freeMergedBuffer();
            }
            return n2;
        }
        return this.mIn.read();
    }

    @Override
    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        if (this.mData != null) {
            int n4 = this.mEnd - this.mPtr;
            if (n3 > n4) {
                n3 = n4;
            }
            System.arraycopy(this.mData, this.mPtr, cArray, n2, n3);
            this.mPtr += n3;
            if (this.mPtr >= this.mEnd) {
                this.freeMergedBuffer();
            }
            return n3;
        }
        return this.mIn.read(cArray, n2, n3);
    }

    @Override
    public boolean ready() throws IOException {
        return this.mData != null || this.mIn.ready();
    }

    @Override
    public void reset() throws IOException {
        if (this.mData == null) {
            this.mIn.reset();
        }
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3 = 0L;
        if (this.mData != null) {
            int n2 = this.mEnd - this.mPtr;
            if ((long)n2 > l2) {
                this.mPtr += (int)l2;
                return n2;
            }
            this.freeMergedBuffer();
            l3 += (long)n2;
            l2 -= (long)n2;
        }
        if (l2 > 0L) {
            l3 += this.mIn.skip(l2);
        }
        return l3;
    }

    private void freeMergedBuffer() {
        if (this.mData != null) {
            char[] cArray = this.mData;
            this.mData = null;
            if (this.mConfig != null) {
                this.mConfig.freeSmallCBuffer(cArray);
            }
        }
    }
}

