/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.ValidationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.SerializationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.BuiltinAtomicType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.SimpleURType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;

public class BooleanType
extends BuiltinAtomicType {
    public static final BooleanType theInstance = new BooleanType();
    private static final long serialVersionUID = 1L;

    private BooleanType() {
        super("boolean");
    }

    @Override
    public final XSDatatype getBaseType() {
        return SimpleURType.theInstance;
    }

    @Override
    protected boolean checkFormat(String string, ValidationContext validationContext) {
        return "true".equals(string) || "false".equals(string) || "0".equals(string) || "1".equals(string);
    }

    @Override
    public Object _createValue(String string, ValidationContext validationContext) {
        return BooleanType.load(string);
    }

    public static Boolean load(String string) {
        if (string.equals("true")) {
            return Boolean.TRUE;
        }
        if (string.equals("1")) {
            return Boolean.TRUE;
        }
        if (string.equals("0")) {
            return Boolean.FALSE;
        }
        if (string.equals("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public String convertToLexicalValue(Object object, SerializationContext serializationContext) {
        if (object instanceof Boolean) {
            return BooleanType.save((Boolean)object);
        }
        throw new IllegalArgumentException();
    }

    public static String save(Boolean bl2) {
        if (bl2.booleanValue()) {
            return "true";
        }
        return "false";
    }

    @Override
    public int isFacetApplicable(String string) {
        if (string.equals("pattern") || string.equals("enumeration") || string.equals("whiteSpace")) {
            return 0;
        }
        return -2;
    }

    @Override
    public Class getJavaObjectType() {
        return Boolean.class;
    }
}

