/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.classic;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.Datatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.DatatypeException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.StringType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionPool;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.trex.TREXGrammar;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.GrammarReaderController;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.IgnoreState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.RunAwayExpressionChecker;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.State;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.TerminalState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.datatype.DataTypeVocabulary;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.datatype.xsd.XSDatatypeExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.datatype.xsd.XSDatatypeResolver;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.IncludePatternState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.RootState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.TREXBaseReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.TREXSequencedStringChecker;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.classic.ConcurState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.classic.DataState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.classic.DefineState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.classic.StringState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.StartTagInfo;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;

public class TREXGrammarReader
extends TREXBaseReader
implements XSDatatypeResolver {
    protected String currentGrammarURI;
    public static final String TREXNamespace = "http://www.thaiopensource.com/trex";
    private boolean issueObsoletedXMLSchemaNamespace = false;

    public static TREXGrammar parse(String string, SAXParserFactory sAXParserFactory, GrammarReaderController grammarReaderController) {
        TREXGrammarReader tREXGrammarReader = new TREXGrammarReader(grammarReaderController, sAXParserFactory, new ExpressionPool());
        tREXGrammarReader.parse(string);
        return tREXGrammarReader.getResult();
    }

    public static TREXGrammar parse(InputSource inputSource, SAXParserFactory sAXParserFactory, GrammarReaderController grammarReaderController) {
        TREXGrammarReader tREXGrammarReader = new TREXGrammarReader(grammarReaderController, sAXParserFactory, new ExpressionPool());
        tREXGrammarReader.parse(inputSource);
        return tREXGrammarReader.getResult();
    }

    public TREXGrammarReader(GrammarReaderController grammarReaderController) {
        this(grammarReaderController, TREXGrammarReader.createParserFactory(), new ExpressionPool());
    }

    public TREXGrammarReader(GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory, ExpressionPool expressionPool) {
        this(grammarReaderController, sAXParserFactory, new StateFactory(), expressionPool);
    }

    public TREXGrammarReader(GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory, StateFactory stateFactory, ExpressionPool expressionPool) {
        super(grammarReaderController, sAXParserFactory, expressionPool, stateFactory, new RootState());
    }

    @Override
    protected String localizeMessage(String string, Object[] objectArray) {
        String string2;
        try {
            string2 = ResourceBundle.getBundle("com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.classic.Messages").getString(string);
        }
        catch (Exception exception) {
            return super.localizeMessage(string, objectArray);
        }
        return MessageFormat.format(string2, objectArray);
    }

    protected TREXGrammar getGrammar() {
        return this.grammar;
    }

    @Override
    protected boolean isGrammarElement(StartTagInfo startTagInfo) {
        if (this.currentGrammarURI == null) {
            if (startTagInfo.namespaceURI.equals(TREXNamespace)) {
                this.currentGrammarURI = TREXNamespace;
                return true;
            }
            if (startTagInfo.namespaceURI.equals("")) {
                this.currentGrammarURI = "";
                return true;
            }
            return false;
        }
        if (this.currentGrammarURI.equals(startTagInfo.namespaceURI)) {
            return true;
        }
        return startTagInfo.containsAttribute(TREXNamespace, "role");
    }

    protected StateFactory getStateFactory() {
        return (StateFactory)this.sfactory;
    }

    private String mapNamespace(String string) {
        if (string.equals("http://www.w3.org/2000/10/XMLSchema") || string.equals("http://www.w3.org/2000/10/XMLSchema-datatypes")) {
            if (!this.issueObsoletedXMLSchemaNamespace) {
                this.reportWarning("TREXGrammarReader.Warning.ObsoletedXMLSchemaNamespace", string);
            }
            this.issueObsoletedXMLSchemaNamespace = true;
            return "http://www.w3.org/2001/XMLSchema-datatypes";
        }
        return string;
    }

    @Override
    public State createExpressionChildState(State state, StartTagInfo startTagInfo) {
        if (startTagInfo.localName.equals("concur")) {
            return this.getStateFactory().concur(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("anyString")) {
            return this.getStateFactory().anyString(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("string")) {
            return this.getStateFactory().string(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("data")) {
            return this.getStateFactory().data(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("include")) {
            return this.getStateFactory().includePattern(state, startTagInfo);
        }
        String string = startTagInfo.getAttribute(TREXNamespace, "role");
        if ("datatype".equals(string)) {
            String string2 = this.mapNamespace(startTagInfo.namespaceURI);
            DataTypeVocabulary dataTypeVocabulary = this.grammar.dataTypes.get(string2);
            if (dataTypeVocabulary == null) {
                this.reportError("TREXGrammarReader.UnknownDataTypeVocabulary", (Object)startTagInfo.namespaceURI);
                this.grammar.dataTypes.put(startTagInfo.namespaceURI, new UndefinedDataTypeVocabulary());
                return new IgnoreState();
            }
            return dataTypeVocabulary.createTopLevelReaderState(startTagInfo);
        }
        return super.createExpressionChildState(state, startTagInfo);
    }

    @Override
    public XSDatatypeExp resolveXSDatatype(String string) {
        return new XSDatatypeExp((XSDatatype)this.resolveDatatype(string), this.pool);
    }

    public Datatype resolveDatatype(String string) {
        String[] stringArray = this.splitQName(string);
        if (stringArray == null) {
            this.reportError("TREXGrammarReader.UndeclaredPrefix", (Object)string);
            return StringType.theInstance;
        }
        stringArray[0] = this.mapNamespace(stringArray[0]);
        DataTypeVocabulary dataTypeVocabulary = this.grammar.dataTypes.get(stringArray[0]);
        if (dataTypeVocabulary == null) {
            this.reportError("TREXGrammarReader.UnknownDataTypeVocabulary", (Object)stringArray[0]);
            this.grammar.dataTypes.put(stringArray[0], new UndefinedDataTypeVocabulary());
        } else {
            try {
                return dataTypeVocabulary.getType(stringArray[1]);
            }
            catch (DatatypeException datatypeException) {
                this.reportError("GrammarReader.UndefinedDataType", (Object)string);
            }
        }
        return StringType.theInstance;
    }

    @Override
    public void wrapUp() {
        RunAwayExpressionChecker.check(this, this.grammar);
        if (!this.controller.hadError()) {
            this.grammar.visit(new TREXSequencedStringChecker(this, false));
        }
    }

    public static class StateFactory
    extends TREXBaseReader.StateFactory {
        public State concur(State state, StartTagInfo startTagInfo) {
            return new ConcurState();
        }

        public State anyString(State state, StartTagInfo startTagInfo) {
            return new TerminalState(Expression.anyString);
        }

        public State string(State state, StartTagInfo startTagInfo) {
            return new StringState();
        }

        public State data(State state, StartTagInfo startTagInfo) {
            return new DataState();
        }

        @Override
        public State define(State state, StartTagInfo startTagInfo) {
            return new DefineState();
        }

        public State includePattern(State state, StartTagInfo startTagInfo) {
            return new IncludePatternState();
        }
    }

    private static class UndefinedDataTypeVocabulary
    implements DataTypeVocabulary {
        private UndefinedDataTypeVocabulary() {
        }

        @Override
        public State createTopLevelReaderState(StartTagInfo startTagInfo) {
            return new IgnoreState();
        }

        @Override
        public Datatype getType(String string) {
            return StringType.theInstance;
        }
    }
}

