/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.std;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.type.WritableTypeId;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;

@JacksonStdImpl
public class JsonValueSerializer
extends StdSerializer<Object>
implements ContextualSerializer {
    protected final AnnotatedMember _accessor;
    protected final TypeSerializer _valueTypeSerializer;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final BeanProperty _property;
    protected final JavaType _valueType;
    protected final boolean _forceTypeInformation;
    protected final Set<String> _ignoredProperties;
    protected transient PropertySerializerMap _dynamicSerializers;

    public JsonValueSerializer(AnnotatedMember annotatedMember, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Set<String> set) {
        super(annotatedMember.getType());
        this._accessor = annotatedMember;
        this._valueType = annotatedMember.getType();
        this._valueTypeSerializer = typeSerializer;
        this._valueSerializer = jsonSerializer;
        this._property = null;
        this._forceTypeInformation = true;
        this._ignoredProperties = set;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
    }

    public JsonValueSerializer(JsonValueSerializer jsonValueSerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, boolean bl2) {
        super(JsonValueSerializer._notNullClass(jsonValueSerializer.handledType()));
        this._accessor = jsonValueSerializer._accessor;
        this._valueType = jsonValueSerializer._valueType;
        this._valueTypeSerializer = typeSerializer;
        this._valueSerializer = jsonSerializer;
        this._property = beanProperty;
        this._forceTypeInformation = bl2;
        this._ignoredProperties = jsonValueSerializer._ignoredProperties;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
    }

    public static JsonValueSerializer construct(SerializationConfig serializationConfig, AnnotatedMember annotatedMember, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer) {
        JsonIgnoreProperties.Value value = serializationConfig.getAnnotationIntrospector().findPropertyIgnoralByName(serializationConfig, annotatedMember);
        Set<String> set = value.findIgnoredForSerialization();
        jsonSerializer = JsonValueSerializer._withIgnoreProperties(jsonSerializer, set);
        return new JsonValueSerializer(annotatedMember, typeSerializer, jsonSerializer, set);
    }

    private static final Class<Object> _notNullClass(Class<?> clazz) {
        return clazz == null ? Object.class : clazz;
    }

    protected JsonValueSerializer withResolved(BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, boolean bl2) {
        if (this._property == beanProperty && this._valueTypeSerializer == typeSerializer && this._valueSerializer == jsonSerializer && bl2 == this._forceTypeInformation) {
            return this;
        }
        return new JsonValueSerializer(this, beanProperty, typeSerializer, jsonSerializer, bl2);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Object object) {
        Object object2 = this._accessor.getValue(object);
        if (object2 == null) {
            return true;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            try {
                jsonSerializer = this._findDynamicSerializer(serializerProvider, object2.getClass());
            }
            catch (JsonMappingException jsonMappingException) {
                throw new RuntimeJsonMappingException(jsonMappingException);
            }
        }
        return jsonSerializer.isEmpty(serializerProvider, object2);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        if (typeSerializer != null) {
            typeSerializer = typeSerializer.forProperty(beanProperty);
        }
        if ((jsonSerializer = this._valueSerializer) == null) {
            if (serializerProvider.isEnabled(MapperFeature.USE_STATIC_TYPING) || this._valueType.isFinal()) {
                jsonSerializer = serializerProvider.findPrimaryPropertySerializer(this._valueType, beanProperty);
                jsonSerializer = JsonValueSerializer._withIgnoreProperties(jsonSerializer, this._ignoredProperties);
                boolean bl2 = this.isNaturalTypeWithStdHandling(this._valueType.getRawClass(), jsonSerializer);
                return this.withResolved(beanProperty, typeSerializer, jsonSerializer, bl2);
            }
            if (beanProperty != this._property) {
                return this.withResolved(beanProperty, typeSerializer, jsonSerializer, this._forceTypeInformation);
            }
        } else {
            jsonSerializer = serializerProvider.handlePrimaryContextualization(jsonSerializer, beanProperty);
            return this.withResolved(beanProperty, typeSerializer, jsonSerializer, this._forceTypeInformation);
        }
        return this;
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Object object2;
        try {
            object2 = this._accessor.getValue(object);
        }
        catch (Exception exception) {
            object2 = null;
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, this._accessor.getName() + "()");
        }
        if (object2 == null) {
            serializerProvider.defaultSerializeNull(jsonGenerator);
        } else {
            JsonSerializer<Object> jsonSerializer = this._valueSerializer;
            if (jsonSerializer == null) {
                jsonSerializer = this._findDynamicSerializer(serializerProvider, object2.getClass());
            }
            if (this._valueTypeSerializer != null) {
                jsonSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, this._valueTypeSerializer);
            } else {
                jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
            }
        }
    }

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        Object object2;
        try {
            object2 = this._accessor.getValue(object);
        }
        catch (Exception exception) {
            object2 = null;
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, this._accessor.getName() + "()");
        }
        if (object2 == null) {
            serializerProvider.defaultSerializeNull(jsonGenerator);
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            jsonSerializer = this._findDynamicSerializer(serializerProvider, object2.getClass());
        } else if (this._forceTypeInformation) {
            WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(object, JsonToken.VALUE_STRING));
            jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
            typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
            return;
        }
        TypeSerializerRerouter typeSerializerRerouter = new TypeSerializerRerouter(typeSerializer, object);
        jsonSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, typeSerializerRerouter);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        if (this._valueSerializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)this._valueSerializer)).getSchema(serializerProvider, null);
        }
        return JsonSchema.getDefaultSchemaNode();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        Class<?> clazz = this._accessor.getDeclaringClass();
        if (clazz != null && ClassUtil.isEnumType(clazz) && this._acceptJsonFormatVisitorForEnum(jsonFormatVisitorWrapper, javaType, clazz)) {
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null && (jsonSerializer = jsonFormatVisitorWrapper.getProvider().findTypedValueSerializer(this._valueType, false, this._property)) == null) {
            jsonFormatVisitorWrapper.expectAnyFormat(javaType);
            return;
        }
        jsonSerializer.acceptJsonFormatVisitor(jsonFormatVisitorWrapper, this._valueType);
    }

    protected boolean _acceptJsonFormatVisitorForEnum(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType, Class<?> clazz) throws JsonMappingException {
        JsonStringFormatVisitor jsonStringFormatVisitor = jsonFormatVisitorWrapper.expectStringFormat(javaType);
        if (jsonStringFormatVisitor != null) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (Object obj : clazz.getEnumConstants()) {
                try {
                    linkedHashSet.add(String.valueOf(this._accessor.getValue(obj)));
                }
                catch (Exception exception) {
                    Throwable throwable = exception;
                    while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
                        throwable = throwable.getCause();
                    }
                    ClassUtil.throwIfError(throwable);
                    throw JsonMappingException.wrapWithPath(throwable, obj, this._accessor.getName() + "()");
                }
            }
            jsonStringFormatVisitor.enumTypes(linkedHashSet);
        }
        return true;
    }

    protected boolean isNaturalTypeWithStdHandling(Class<?> clazz, JsonSerializer<?> jsonSerializer) {
        if (clazz.isPrimitive() ? clazz != Integer.TYPE && clazz != Boolean.TYPE && clazz != Double.TYPE : clazz != String.class && clazz != Integer.class && clazz != Boolean.class && clazz != Double.class) {
            return false;
        }
        return this.isDefaultSerializer(jsonSerializer);
    }

    protected JsonSerializer<Object> _findDynamicSerializer(SerializerProvider serializerProvider, Class<?> clazz) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this._dynamicSerializers.serializerFor(clazz);
        if (jsonSerializer == null) {
            if (this._valueType.hasGenericTypes()) {
                JavaType javaType = serializerProvider.constructSpecializedType(this._valueType, clazz);
                jsonSerializer = serializerProvider.findPrimaryPropertySerializer(javaType, this._property);
                jsonSerializer = JsonValueSerializer._withIgnoreProperties(jsonSerializer, this._ignoredProperties);
                PropertySerializerMap.SerializerAndMapResult serializerAndMapResult = this._dynamicSerializers.addSerializer(javaType, jsonSerializer);
                this._dynamicSerializers = serializerAndMapResult.map;
            } else {
                jsonSerializer = serializerProvider.findPrimaryPropertySerializer(clazz, this._property);
                jsonSerializer = JsonValueSerializer._withIgnoreProperties(jsonSerializer, this._ignoredProperties);
                PropertySerializerMap.SerializerAndMapResult serializerAndMapResult = this._dynamicSerializers.addSerializer(clazz, jsonSerializer);
                this._dynamicSerializers = serializerAndMapResult.map;
            }
        }
        return jsonSerializer;
    }

    protected static JsonSerializer<Object> _withIgnoreProperties(JsonSerializer<?> jsonSerializer, Set<String> set) {
        if (jsonSerializer != null && !set.isEmpty()) {
            jsonSerializer = jsonSerializer.withIgnoredProperties(set);
        }
        return jsonSerializer;
    }

    public String toString() {
        return "(@JsonValue serializer for method " + this._accessor.getDeclaringClass() + "#" + this._accessor.getName() + ")";
    }

    static class TypeSerializerRerouter
    extends TypeSerializer {
        protected final TypeSerializer _typeSerializer;
        protected final Object _forObject;

        public TypeSerializerRerouter(TypeSerializer typeSerializer, Object object) {
            this._typeSerializer = typeSerializer;
            this._forObject = object;
        }

        @Override
        public TypeSerializer forProperty(BeanProperty beanProperty) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JsonTypeInfo.As getTypeInclusion() {
            return this._typeSerializer.getTypeInclusion();
        }

        @Override
        public String getPropertyName() {
            return this._typeSerializer.getPropertyName();
        }

        @Override
        public WritableTypeId writeTypePrefix(JsonGenerator jsonGenerator, WritableTypeId writableTypeId) throws IOException {
            writableTypeId.forValue = this._forObject;
            return this._typeSerializer.writeTypePrefix(jsonGenerator, writableTypeId);
        }

        @Override
        public WritableTypeId writeTypeSuffix(JsonGenerator jsonGenerator, WritableTypeId writableTypeId) throws IOException {
            return this._typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
        }
    }
}

