/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.util.DurationUnitConverter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.format.DateTimeFormatter;

public class DurationSerializer
extends JSR310FormattedSerializerBase<Duration> {
    public static final DurationSerializer INSTANCE = new DurationSerializer();
    private DurationUnitConverter _durationUnitConverter;

    protected DurationSerializer() {
        super(Duration.class);
    }

    protected DurationSerializer(DurationSerializer durationSerializer, Boolean bl2, DateTimeFormatter dateTimeFormatter) {
        super(durationSerializer, bl2, dateTimeFormatter, null);
    }

    protected DurationSerializer(DurationSerializer durationSerializer, Boolean bl2, Boolean bl3, DateTimeFormatter dateTimeFormatter) {
        super(durationSerializer, bl2, bl3, dateTimeFormatter, null);
    }

    protected DurationSerializer(DurationSerializer durationSerializer, DurationUnitConverter durationUnitConverter) {
        super(durationSerializer, durationSerializer._useTimestamp, durationSerializer._useNanoseconds, durationSerializer._formatter, durationSerializer._shape);
        this._durationUnitConverter = durationUnitConverter;
    }

    protected DurationSerializer withFormat(Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        return new DurationSerializer(this, bl2, dateTimeFormatter);
    }

    protected DurationSerializer withConverter(DurationUnitConverter durationUnitConverter) {
        return new DurationSerializer(this, durationUnitConverter);
    }

    @Override
    protected SerializationFeature getTimestampsFeature() {
        return SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        DurationSerializer durationSerializer = (DurationSerializer)super.createContextual(serializerProvider, beanProperty);
        JsonFormat.Value value = this.findFormatOverrides(serializerProvider, beanProperty, this.handledType());
        if (value != null && value.hasPattern()) {
            String string = value.getPattern();
            DurationUnitConverter durationUnitConverter = DurationUnitConverter.from(string);
            if (durationUnitConverter == null) {
                serializerProvider.reportBadDefinition(this.handledType(), String.format("Bad 'pattern' definition (\"%s\") for `Duration`: expected one of [%s]", string, DurationUnitConverter.descForAllowed()));
            }
            durationSerializer = durationSerializer.withConverter(durationUnitConverter);
        }
        return durationSerializer;
    }

    @Override
    public void serialize(Duration duration, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.useTimestamp(serializerProvider)) {
            if (this._durationUnitConverter != null) {
                jsonGenerator.writeNumber(this._durationUnitConverter.convert(duration));
            } else if (this.useNanoseconds(serializerProvider)) {
                jsonGenerator.writeNumber(this._toNanos(duration));
            } else {
                jsonGenerator.writeNumber(duration.toMillis());
            }
        } else {
            jsonGenerator.writeString(duration.toString());
        }
    }

    private BigDecimal _toNanos(Duration duration) {
        BigDecimal bigDecimal;
        if (duration.isNegative()) {
            duration = duration.abs();
            bigDecimal = DecimalUtils.toBigDecimal(duration.getSeconds(), duration.getNano()).negate();
        } else {
            bigDecimal = DecimalUtils.toBigDecimal(duration.getSeconds(), duration.getNano());
        }
        return bigDecimal;
    }

    @Override
    protected void _acceptTimestampVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        JsonIntegerFormatVisitor jsonIntegerFormatVisitor = jsonFormatVisitorWrapper.expectIntegerFormat(javaType);
        if (jsonIntegerFormatVisitor != null) {
            jsonIntegerFormatVisitor.numberType(JsonParser.NumberType.LONG);
            SerializerProvider serializerProvider = jsonFormatVisitorWrapper.getProvider();
            if (serializerProvider == null || !this.useNanoseconds(serializerProvider)) {
                jsonIntegerFormatVisitor.format(JsonValueFormat.UTC_MILLISEC);
            }
        }
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider serializerProvider) {
        if (this.useTimestamp(serializerProvider)) {
            if (this.useNanoseconds(serializerProvider)) {
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
            return JsonToken.VALUE_NUMBER_INT;
        }
        return JsonToken.VALUE_STRING;
    }

    @Override
    protected JSR310FormattedSerializerBase<?> withFeatures(Boolean bl2, Boolean bl3) {
        return new DurationSerializer(this, this._useTimestamp, bl3, this._formatter);
    }

    @Override
    protected DateTimeFormatter _useDateTimeFormatter(SerializerProvider serializerProvider, JsonFormat.Value value) {
        return null;
    }
}

