/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.base;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Enums;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Optional;
import com.gradle.maven.extension.internal.dep.com.google.common.base.PatternCompiler;
import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.logging.Logger;

final class Platform {
    private static final Logger logger = Logger.getLogger(Platform.class.getName());
    private static final PatternCompiler patternCompiler = Platform.loadPatternCompiler();

    private Platform() {
    }

    static <T extends Enum<T>> Optional<T> getEnumIfPresent(Class<T> clazz, String string) {
        WeakReference<Enum<?>> weakReference = Enums.getEnumConstants(clazz).get(string);
        return weakReference == null ? Optional.absent() : Optional.of((Enum)clazz.cast(weakReference.get()));
    }

    static String formatCompact4Digits(double d2) {
        return String.format(Locale.ROOT, "%.4g", d2);
    }

    static boolean stringIsNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    static String nullToEmpty(String string) {
        return string == null ? "" : string;
    }

    static String emptyToNull(String string) {
        return Platform.stringIsNullOrEmpty(string) ? null : string;
    }

    private static PatternCompiler loadPatternCompiler() {
        return new JdkPatternCompiler();
    }

    private static final class JdkPatternCompiler
    implements PatternCompiler {
        private JdkPatternCompiler() {
        }
    }
}

