/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel.socket.nio;

import com.gradle.maven.extension.internal.dep.io.netty.channel.socket.InternetProtocolFamily;
import com.gradle.maven.extension.internal.dep.io.netty.channel.socket.nio.ProtocolFamilyConverter;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ProtocolFamily;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;

final class SelectorProviderUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SelectorProviderUtil.class);

    static Method findOpenMethod(String string) {
        if (PlatformDependent.javaVersion() >= 15) {
            try {
                return SelectorProvider.class.getMethod(string, ProtocolFamily.class);
            }
            catch (Throwable throwable) {
                logger.debug("SelectorProvider.{}(ProtocolFamily) not available, will use default", (Object)string, (Object)throwable);
            }
        }
        return null;
    }

    static <C extends Channel> C newChannel(Method method, SelectorProvider selectorProvider, InternetProtocolFamily internetProtocolFamily) throws IOException {
        if (internetProtocolFamily != null && method != null) {
            try {
                Channel channel = (Channel)method.invoke((Object)selectorProvider, ProtocolFamilyConverter.convert(internetProtocolFamily));
                return (C)channel;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IOException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException(illegalAccessException);
            }
        }
        return null;
    }

    private SelectorProviderUtil() {
    }
}

