/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.MessageToMessageEncoder;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.TooLongFrameException;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCounted;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteOrder;
import java.util.List;

public class WebSocket08FrameEncoder
extends MessageToMessageEncoder<WebSocketFrame>
implements WebSocketFrameEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocket08FrameEncoder.class);
    private final boolean maskPayload;

    public WebSocket08FrameEncoder(boolean bl2) {
        this.maskPayload = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) throws Exception {
        int n2;
        ByteBuf byteBuf = webSocketFrame.content();
        if (webSocketFrame instanceof TextWebSocketFrame) {
            n2 = 1;
        } else if (webSocketFrame instanceof PingWebSocketFrame) {
            n2 = 9;
        } else if (webSocketFrame instanceof PongWebSocketFrame) {
            n2 = 10;
        } else if (webSocketFrame instanceof CloseWebSocketFrame) {
            n2 = 8;
        } else if (webSocketFrame instanceof BinaryWebSocketFrame) {
            n2 = 2;
        } else if (webSocketFrame instanceof ContinuationWebSocketFrame) {
            n2 = 0;
        } else {
            throw new UnsupportedOperationException("Cannot encode frame of type: " + webSocketFrame.getClass().getName());
        }
        int n3 = byteBuf.readableBytes();
        if (logger.isTraceEnabled()) {
            logger.trace("Encoding WebSocket Frame opCode={} length={}", (byte)n2, n3);
        }
        int n4 = 0;
        if (webSocketFrame.isFinalFragment()) {
            n4 |= 0x80;
        }
        n4 |= webSocketFrame.rsv() % 8 << 4;
        n4 |= n2 % 128;
        if (n2 == 9 && n3 > 125) {
            throw new TooLongFrameException("invalid payload for PING (payload length must be <= 125, was " + n3);
        }
        boolean bl2 = true;
        ReferenceCounted referenceCounted = null;
        try {
            int n5;
            int n6;
            int n7 = n6 = this.maskPayload ? 4 : 0;
            if (n3 <= 125) {
                n5 = 2 + n6 + n3;
                referenceCounted = channelHandlerContext.alloc().buffer(n5);
                ((ByteBuf)referenceCounted).writeByte(n4);
                byte by2 = this.maskPayload ? (byte)(0x80 | (byte)n3) : (byte)n3;
                ((ByteBuf)referenceCounted).writeByte(by2);
            } else if (n3 <= 65535) {
                n5 = 4 + n6;
                if (this.maskPayload || n3 <= 1024) {
                    n5 += n3;
                }
                referenceCounted = channelHandlerContext.alloc().buffer(n5);
                ((ByteBuf)referenceCounted).writeByte(n4);
                ((ByteBuf)referenceCounted).writeByte(this.maskPayload ? 254 : 126);
                ((ByteBuf)referenceCounted).writeByte(n3 >>> 8 & 0xFF);
                ((ByteBuf)referenceCounted).writeByte(n3 & 0xFF);
            } else {
                n5 = 10 + n6;
                if (this.maskPayload) {
                    n5 += n3;
                }
                referenceCounted = channelHandlerContext.alloc().buffer(n5);
                ((ByteBuf)referenceCounted).writeByte(n4);
                ((ByteBuf)referenceCounted).writeByte(this.maskPayload ? 255 : 127);
                ((ByteBuf)referenceCounted).writeLong(n3);
            }
            if (this.maskPayload) {
                n5 = PlatformDependent.threadLocalRandom().nextInt(Integer.MAX_VALUE);
                ((ByteBuf)referenceCounted).writeInt(n5);
                if (byteBuf.isReadable()) {
                    ByteOrder byteOrder = byteBuf.order();
                    ByteOrder byteOrder2 = ((ByteBuf)referenceCounted).order();
                    int n8 = byteBuf.readerIndex();
                    int n9 = byteBuf.writerIndex();
                    if (byteOrder == byteOrder2) {
                        long l2 = (long)n5 & 0xFFFFFFFFL;
                        l2 |= l2 << 32;
                        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                            l2 = Long.reverseBytes(l2);
                        }
                        int n10 = n9 - 7;
                        while (n8 < n10) {
                            ((ByteBuf)referenceCounted).writeLong(byteBuf.getLong(n8) ^ l2);
                            n8 += 8;
                        }
                        if (n8 < n9 - 3) {
                            ((ByteBuf)referenceCounted).writeInt(byteBuf.getInt(n8) ^ (int)l2);
                            n8 += 4;
                        }
                    }
                    int n11 = 0;
                    while (n8 < n9) {
                        byte by3 = byteBuf.getByte(n8);
                        ((ByteBuf)referenceCounted).writeByte(by3 ^ WebSocketUtil.byteAtIndex(n5, n11++ & 3));
                        ++n8;
                    }
                }
                list.add(referenceCounted);
            } else if (((ByteBuf)referenceCounted).writableBytes() >= byteBuf.readableBytes()) {
                ((ByteBuf)referenceCounted).writeBytes(byteBuf);
                list.add(referenceCounted);
            } else {
                list.add(referenceCounted);
                list.add(byteBuf.retain());
            }
            bl2 = false;
        }
        finally {
            if (bl2 && referenceCounted != null) {
                referenceCounted.release();
            }
        }
    }
}

