/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.input;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BoundedInputStream
extends FilterInputStream {
    private final long maxCount;
    private long count;
    private long mark = -1L;
    private boolean propagateClose = true;

    public BoundedInputStream(InputStream inputStream, long l2) {
        super(inputStream);
        this.maxCount = l2;
    }

    @Override
    public int available() throws IOException {
        if (this.isMaxLength()) {
            this.onMaxLength(this.maxCount, this.count);
            return 0;
        }
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        if (this.propagateClose) {
            this.in.close();
        }
    }

    private boolean isMaxLength() {
        return this.maxCount >= 0L && this.count >= this.maxCount;
    }

    @Override
    public synchronized void mark(int n2) {
        this.in.mark(n2);
        this.mark = this.count;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    protected void onMaxLength(long l2, long l3) throws IOException {
    }

    @Override
    public int read() throws IOException {
        if (this.isMaxLength()) {
            this.onMaxLength(this.maxCount, this.count);
            return -1;
        }
        int n2 = this.in.read();
        ++this.count;
        return n2;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.isMaxLength()) {
            this.onMaxLength(this.maxCount, this.count);
            return -1;
        }
        long l2 = this.maxCount >= 0L ? Math.min((long)n3, this.maxCount - this.count) : (long)n3;
        int n4 = this.in.read(byArray, n2, (int)l2);
        if (n4 == -1) {
            return -1;
        }
        this.count += (long)n4;
        return n4;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.count = this.mark;
    }

    public void setPropagateClose(boolean bl2) {
        this.propagateClose = bl2;
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3 = this.maxCount >= 0L ? Math.min(l2, this.maxCount - this.count) : l2;
        long l4 = this.in.skip(l3);
        this.count += l4;
        return l4;
    }

    public String toString() {
        return this.in.toString();
    }
}

