/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.Type;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Operator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.TypeReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.BooleanTypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;

public class OperatorInstanceof
extends Operator {
    private Class<?> type;

    public OperatorInstanceof(int n2, int n3, SpelNodeImpl ... spelNodeImplArray) {
        super("instanceof", n2, n3, spelNodeImplArray);
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        SpelNodeImpl spelNodeImpl = this.getRightOperand();
        TypedValue typedValue = this.getLeftOperand().getValueInternal(expressionState);
        TypedValue typedValue2 = spelNodeImpl.getValueInternal(expressionState);
        Object object = typedValue.getValue();
        Object object2 = typedValue2.getValue();
        if (!(object2 instanceof Class)) {
            throw new SpelEvaluationException(this.getRightOperand().getStartPosition(), SpelMessage.INSTANCEOF_OPERATOR_NEEDS_CLASS_OPERAND, object2 == null ? "null" : object2.getClass().getName());
        }
        Class clazz = (Class)object2;
        BooleanTypedValue booleanTypedValue = object == null ? BooleanTypedValue.FALSE : BooleanTypedValue.forValue(clazz.isAssignableFrom(object.getClass()));
        this.type = clazz;
        if (spelNodeImpl instanceof TypeReference) {
            this.exitTypeDescriptor = "Z";
        }
        return booleanTypedValue;
    }

    @Override
    public boolean isCompilable() {
        return this.exitTypeDescriptor != null && this.getLeftOperand().isCompilable();
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        this.getLeftOperand().generateCode(methodVisitor, codeFlow);
        CodeFlow.insertBoxIfNecessary(methodVisitor, codeFlow.lastDescriptor());
        Assert.state(this.type != null, "No type available");
        if (this.type.isPrimitive()) {
            methodVisitor.visitInsn(87);
            methodVisitor.visitInsn(3);
        } else {
            methodVisitor.visitTypeInsn(193, Type.getInternalName(this.type));
        }
        codeFlow.pushDescriptor(this.exitTypeDescriptor);
    }
}

