/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.hardware.platform.windows;

import com.gradle.maven.extension.internal.dep.oshi.driver.windows.perfmon.MemoryInformation;
import com.gradle.maven.extension.internal.dep.oshi.driver.windows.perfmon.PagingFile;
import com.gradle.maven.extension.internal.dep.oshi.hardware.common.AbstractVirtualMemory;
import com.gradle.maven.extension.internal.dep.oshi.hardware.platform.windows.WindowsGlobalMemory;
import com.gradle.maven.extension.internal.dep.oshi.jna.Struct;
import com.gradle.maven.extension.internal.dep.oshi.util.Memoizer;
import com.gradle.maven.extension.internal.dep.oshi.util.tuples.Pair;
import com.gradle.maven.extension.internal.dep.oshi.util.tuples.Triplet;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WindowsVirtualMemory
extends AbstractVirtualMemory {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsVirtualMemory.class);
    private final WindowsGlobalMemory global;
    private final Supplier<Long> used = Memoizer.memoize(WindowsVirtualMemory::querySwapUsed, Memoizer.defaultExpiration());
    private final Supplier<Triplet<Long, Long, Long>> totalVmaxVused = Memoizer.memoize(WindowsVirtualMemory::querySwapTotalVirtMaxVirtUsed, Memoizer.defaultExpiration());
    private final Supplier<Pair<Long, Long>> swapInOut = Memoizer.memoize(WindowsVirtualMemory::queryPageSwaps, Memoizer.defaultExpiration());

    WindowsVirtualMemory(WindowsGlobalMemory windowsGlobalMemory) {
        this.global = windowsGlobalMemory;
    }

    @Override
    public long getSwapUsed() {
        return this.global.getPageSize() * this.used.get();
    }

    @Override
    public long getSwapTotal() {
        return this.global.getPageSize() * this.totalVmaxVused.get().getA();
    }

    @Override
    public long getVirtualMax() {
        return this.global.getPageSize() * this.totalVmaxVused.get().getB();
    }

    @Override
    public long getVirtualInUse() {
        return this.global.getPageSize() * this.totalVmaxVused.get().getC();
    }

    private static long querySwapUsed() {
        return PagingFile.querySwapUsed().getOrDefault(PagingFile.PagingPercentProperty.PERCENTUSAGE, 0L);
    }

    private static Triplet<Long, Long, Long> querySwapTotalVirtMaxVirtUsed() {
        try (Struct.CloseablePerformanceInformation closeablePerformanceInformation = new Struct.CloseablePerformanceInformation();){
            if (!Psapi.INSTANCE.GetPerformanceInfo(closeablePerformanceInformation, closeablePerformanceInformation.size())) {
                LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
                Triplet<Long, Long, Long> triplet = new Triplet<Long, Long, Long>(0L, 0L, 0L);
                return triplet;
            }
            Triplet<Long, Long, Long> triplet = new Triplet<Long, Long, Long>(closeablePerformanceInformation.CommitLimit.longValue() - closeablePerformanceInformation.PhysicalTotal.longValue(), closeablePerformanceInformation.CommitLimit.longValue(), closeablePerformanceInformation.CommitTotal.longValue());
            return triplet;
        }
    }

    private static Pair<Long, Long> queryPageSwaps() {
        Map<MemoryInformation.PageSwapProperty, Long> map = MemoryInformation.queryPageSwaps();
        return new Pair<Long, Long>(map.getOrDefault(MemoryInformation.PageSwapProperty.PAGESINPUTPERSEC, 0L), map.getOrDefault(MemoryInformation.PageSwapProperty.PAGESOUTPUTPERSEC, 0L));
    }
}

