/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.Runnables;
import java.io.File;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.AbstractCrossProcessCacheAccess;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.internal.UncheckedException;

public class FixedExclusiveModeCrossProcessCacheAccess
extends AbstractCrossProcessCacheAccess {
    private final String cacheDisplayName;
    private final File lockTarget;
    private final LockOptions lockOptions;
    private final FileLockManager lockManager;
    private final CacheInitializationAction initializationAction;
    private final Consumer<FileLock> onOpenAction;
    private final Consumer<FileLock> onCloseAction;
    private FileLock fileLock;

    public FixedExclusiveModeCrossProcessCacheAccess(String string, File file, LockOptions lockOptions, FileLockManager fileLockManager, CacheInitializationAction cacheInitializationAction, Consumer<FileLock> consumer, Consumer<FileLock> consumer2) {
        assert (lockOptions.getMode() == FileLockManager.LockMode.Exclusive);
        this.initializationAction = cacheInitializationAction;
        this.onOpenAction = consumer;
        this.onCloseAction = consumer2;
        assert (lockOptions.getMode() == FileLockManager.LockMode.Exclusive);
        this.cacheDisplayName = string;
        this.lockTarget = file;
        this.lockOptions = lockOptions;
        this.lockManager = fileLockManager;
    }

    @Override
    public void open() {
        if (this.fileLock != null) {
            throw new IllegalStateException("File lock " + this.lockTarget + " is already open.");
        }
        FileLock fileLock = this.lockManager.lock(this.lockTarget, this.lockOptions, this.cacheDisplayName, "", fileLockReleasedSignal -> {});
        try {
            boolean bl2 = this.initializationAction.requiresInitialization(fileLock);
            if (bl2) {
                fileLock.writeFile(() -> this.initializationAction.initialize(fileLock));
            }
            this.onOpenAction.accept(fileLock);
        }
        catch (Exception exception) {
            fileLock.close();
            throw UncheckedException.throwAsUncheckedException(exception);
        }
        this.fileLock = fileLock;
    }

    @Override
    public void close() {
        if (this.fileLock != null) {
            try {
                this.onCloseAction.accept(this.fileLock);
                this.fileLock.close();
            }
            finally {
                this.fileLock = null;
            }
        }
    }

    @Override
    public Runnable acquireFileLock() {
        return Runnables.doNothing();
    }

    @Override
    public <T> T withFileLock(Supplier<T> supplier) {
        return supplier.get();
    }
}

