/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.exceptions.DefaultMultiCauseException;

public class CompositeStoppable
implements Stoppable {
    public static final Stoppable NO_OP_STOPPABLE = new Stoppable(){

        @Override
        public void stop() {
        }
    };
    private final List<Stoppable> elements = new ArrayList<Stoppable>();

    public static CompositeStoppable stoppable(Iterable<?> iterable) {
        return new CompositeStoppable().add(iterable);
    }

    public CompositeStoppable add(Iterable<?> iterable) {
        for (Object obj : iterable) {
            this.add(obj);
        }
        return this;
    }

    public synchronized CompositeStoppable add(Object object) {
        this.elements.add(CompositeStoppable.toStoppable(object));
        return this;
    }

    private static Stoppable toStoppable(Object object) {
        if (object instanceof Stoppable) {
            return (Stoppable)object;
        }
        if (object instanceof Closeable) {
            final Closeable closeable = (Closeable)object;
            return new Stoppable(){

                public String toString() {
                    return closeable.toString();
                }

                @Override
                public void stop() {
                    try {
                        closeable.close();
                    }
                    catch (IOException iOException) {
                        throw UncheckedException.throwAsUncheckedException(iOException);
                    }
                }
            };
        }
        return NO_OP_STOPPABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        ArrayList<Throwable> arrayList = null;
        try {
            for (Stoppable stoppable : this.elements) {
                try {
                    stoppable.stop();
                }
                catch (Throwable throwable) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Throwable>();
                    }
                    arrayList.add(throwable);
                }
            }
        }
        finally {
            this.elements.clear();
        }
        if (arrayList != null) {
            if (arrayList.size() == 1) {
                throw UncheckedException.throwAsUncheckedException((Throwable)arrayList.get(0));
            }
            throw new DefaultMultiCauseException("Could not stop all services.", arrayList);
        }
    }
}

