/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ExecutorPolicy;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.ManagedExecutorImpl;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.concurrent.ThreadFactoryImpl;

public class DefaultExecutorFactory
implements ExecutorFactory,
Stoppable {
    private final Set<ManagedExecutor> executors = new CopyOnWriteArraySet<ManagedExecutor>();
    private final ClassLoader threadFactoryContextClassloader;

    public DefaultExecutorFactory() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public DefaultExecutorFactory(ClassLoader classLoader) {
        this.threadFactoryContextClassloader = classLoader;
    }

    @Override
    public void stop() {
        try {
            CompositeStoppable.stoppable(this.executors).stop();
        }
        finally {
            this.executors.clear();
        }
    }

    @Override
    public ManagedExecutor create(String string) {
        TrackedManagedExecutor trackedManagedExecutor = new TrackedManagedExecutor(this.createExecutor(string), new ExecutorPolicy.CatchAndRecordFailures());
        this.executors.add(trackedManagedExecutor);
        return trackedManagedExecutor;
    }

    protected ExecutorService createExecutor(String string) {
        return Executors.newCachedThreadPool(this.newThreadFactory(string));
    }

    private ThreadFactory newThreadFactory(String string) {
        return new ThreadFactoryImpl(string, this.threadFactoryContextClassloader);
    }

    private class TrackedManagedExecutor
    extends ManagedExecutorImpl {
        TrackedManagedExecutor(ExecutorService executorService, ExecutorPolicy executorPolicy) {
            super(executorService, executorPolicy);
        }

        @Override
        public void stop(int n2, TimeUnit timeUnit) throws IllegalStateException {
            try {
                super.stop(n2, timeUnit);
            }
            finally {
                DefaultExecutorFactory.this.executors.remove(this);
            }
        }
    }
}

