/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file;

import java.util.Locale;

public class PathTraversalChecker {
    public static String safePathName(String string) {
        if (PathTraversalChecker.isUnsafePathName(string)) {
            throw new IllegalArgumentException(String.format("'%s' is not a safe archive entry or path name.", string));
        }
        return string;
    }

    public static boolean isUnsafePathName(String string) {
        return string.isEmpty() || string.startsWith("/") || string.startsWith("\\") || PathTraversalChecker.containsDirectoryNavigation(string) || string.contains(":") && PathTraversalChecker.isWindows();
    }

    private static boolean containsDirectoryNavigation(String string) {
        if (!string.contains("..")) {
            return false;
        }
        return string.endsWith("\\..") || string.contains("..\\") || string.endsWith("/..") || string.contains("../");
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.US).contains("windows");
    }
}

