/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.normalization.java.impl;

import com.gradle.maven.extension.internal.dep.org.objectweb.asm.AnnotationVisitor;
import java.util.LinkedList;
import java.util.List;
import org.gradle.internal.normalization.java.impl.AnnotationAnnotationValue;
import org.gradle.internal.normalization.java.impl.AnnotationMember;
import org.gradle.internal.normalization.java.impl.AnnotationValue;
import org.gradle.internal.normalization.java.impl.ArrayAnnotationValue;
import org.gradle.internal.normalization.java.impl.EnumAnnotationValue;
import org.gradle.internal.normalization.java.impl.SimpleAnnotationValue;

public class SortingAnnotationVisitor
extends AnnotationVisitor {
    private final List<AnnotationValue<?>> annotationValues = new LinkedList();
    private final AnnotationMember annotation;
    private SortingAnnotationVisitor parentVisitor;
    private String annotationValueName;
    private String arrayValueName;

    public SortingAnnotationVisitor(AnnotationMember annotationMember, AnnotationVisitor annotationVisitor) {
        super(589824, annotationVisitor);
        this.annotation = annotationMember;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, String string2) {
        AnnotationMember annotationMember = new AnnotationMember(string2, true);
        SortingAnnotationVisitor sortingAnnotationVisitor = new SortingAnnotationVisitor(annotationMember, super.visitAnnotation(string, string2));
        sortingAnnotationVisitor.parentVisitor = this;
        sortingAnnotationVisitor.annotationValueName = this.nameOrValue(string);
        return sortingAnnotationVisitor;
    }

    @Override
    public void visit(String string, Object object) {
        this.annotationValues.add(new SimpleAnnotationValue(this.nameOrValue(string), object));
        super.visit(string, object);
    }

    @Override
    public AnnotationVisitor visitArray(String string) {
        SortingAnnotationVisitor sortingAnnotationVisitor = new SortingAnnotationVisitor(this.annotation, super.visitArray(string));
        sortingAnnotationVisitor.arrayValueName = string;
        return sortingAnnotationVisitor;
    }

    @Override
    public void visitEnum(String string, String string2, String string3) {
        this.annotationValues.add(new EnumAnnotationValue(this.nameOrValue(string), string3, string2));
        super.visitEnum(string, string2, string3);
    }

    @Override
    public void visitEnd() {
        if (this.annotationValueName != null) {
            AnnotationAnnotationValue annotationAnnotationValue = new AnnotationAnnotationValue(this.annotationValueName, this.annotation);
            this.parentVisitor.annotationValues.add(annotationAnnotationValue);
            this.annotationValueName = null;
        } else if (this.arrayValueName != null) {
            ArrayAnnotationValue arrayAnnotationValue = new ArrayAnnotationValue(this.arrayValueName, this.annotationValues.toArray(new AnnotationValue[0]));
            this.annotation.addValue(arrayAnnotationValue);
            this.arrayValueName = null;
        }
        this.annotation.addValues(this.annotationValues);
        this.annotationValues.clear();
        super.visitEnd();
    }

    private String nameOrValue(String string) {
        return string == null ? "value" : string;
    }
}

