/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableListMultimap;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class SnapshotUtil {
    public static Map<String, FileSystemLocationSnapshot> indexByAbsolutePath(FileSystemSnapshot fileSystemSnapshot) {
        HashMap<String, FileSystemLocationSnapshot> hashMap = new HashMap<String, FileSystemLocationSnapshot>();
        fileSystemSnapshot.accept(fileSystemLocationSnapshot -> {
            hashMap.put(fileSystemLocationSnapshot.getAbsolutePath(), fileSystemLocationSnapshot);
            return SnapshotVisitResult.CONTINUE;
        });
        return hashMap;
    }

    public static ImmutableListMultimap<String, HashCode> getRootHashes(FileSystemSnapshot fileSystemSnapshot) {
        if (fileSystemSnapshot == FileSystemSnapshot.EMPTY) {
            return ImmutableListMultimap.of();
        }
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        fileSystemSnapshot.accept(fileSystemLocationSnapshot -> {
            builder.put(fileSystemLocationSnapshot.getAbsolutePath(), fileSystemLocationSnapshot.getHash());
            return SnapshotVisitResult.SKIP_SUBTREE;
        });
        return builder.build();
    }
}

