/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.datavisualization.chart.options;

import com.google.gson.JsonElement;
import com.grapecity.datavisualization.chart.enums.ValueOptionType;
import com.grapecity.datavisualization.chart.options.IValueOption;
import com.grapecity.datavisualization.chart.options.Option;
import com.grapecity.datavisualization.chart.options.json.ConverterAttribute;
import com.grapecity.datavisualization.chart.options.json.ValueOptionValueConverter;

public class ValueOption
extends Option
implements IValueOption {
    private ValueOptionType a;
    private double b;

    @Override
    protected void init() {
        super.init();
        this.a = ValueOptionType.Pixel;
        this.b = 0.0;
    }

    @Override
    public ValueOptionType getType() {
        return this.a;
    }

    public void setType(ValueOptionType valueOptionType) {
        this.a = valueOptionType;
    }

    @Override
    public double getValue() {
        return this.b;
    }

    @Override
    public void setValue(@ConverterAttribute(value=ValueOptionValueConverter.class) double d2) {
        if (this.b != d2) {
            this.b = d2;
            this.__isEmpty = false;
        }
    }

    public ValueOption(JsonElement jsonElement) {
        super(jsonElement);
    }

    public ValueOption() {
    }

    @Override
    public Object _clone() {
        ValueOption valueOption = new ValueOption(this.option());
        valueOption.setValue(this.getValue());
        valueOption.setType(this.getType());
        return valueOption;
    }

    public static boolean isValidPixelPercentage(IValueOption iValueOption) {
        return ValueOption.isValidPixelPercentage(iValueOption, true);
    }

    public static boolean isValidPixelPercentage(IValueOption iValueOption, boolean bl2) {
        switch (iValueOption.getType()) {
            case Percentage: {
                if (bl2) {
                    return 0.0 < iValueOption.getValue() && iValueOption.getValue() < 1.0;
                }
                return 0.0 <= iValueOption.getValue() && iValueOption.getValue() <= 1.0;
            }
            case Pixel: {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidNumberDate(IValueOption iValueOption) {
        switch (iValueOption.getType()) {
            case Number: 
            case Date: {
                return true;
            }
        }
        return false;
    }
}

