/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.datavisualization.chart.options.json;

import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.grapecity.datavisualization.chart.options.json.JsonConverter;
import com.grapecity.datavisualization.chart.options.json.b;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class AnglesConverter
extends JsonConverter<ArrayList<Double>> {
    public ArrayList<Double> read(JsonReader jsonReader) throws IOException {
        ArrayList<Double> arrayList = null;
        switch (jsonReader.peek()) {
            case STRING: {
                arrayList = AnglesConverter.createFromString(jsonReader.nextString());
                break;
            }
            case NUMBER: {
                arrayList = AnglesConverter.createFromNumber(jsonReader.nextDouble());
                break;
            }
            case BEGIN_ARRAY: {
                arrayList = AnglesConverter.createFromArray(b.a(jsonReader));
                break;
            }
        }
        return arrayList;
    }

    public void write(JsonWriter jsonWriter, ArrayList<Double> arrayList) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static ArrayList<Double> create(JsonElement jsonElement) {
        if (jsonElement.isJsonArray()) {
            return AnglesConverter.createFromArray((JsonElement)jsonElement.getAsJsonArray());
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isNumber()) {
            return AnglesConverter.createFromNumber(jsonElement.getAsDouble());
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
            return AnglesConverter.createFromString(jsonElement.getAsString());
        }
        return null;
    }

    public static ArrayList<Double> createFromString(String string) {
        String[] stringArray;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (String string2 : stringArray = string.split(",+")) {
            String string3 = string2.trim();
            if (b.a(string3)) continue;
            arrayList.add(Double.parseDouble(string3));
        }
        return arrayList;
    }

    public static ArrayList<Double> createFromNumber(double d2) {
        return new ArrayList<Double>(Arrays.asList(d2));
    }

    public static ArrayList<Double> createFromArray(JsonElement jsonElement) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (JsonElement jsonElement2 : jsonElement.getAsJsonArray()) {
            arrayList.add(jsonElement2.getAsDouble());
        }
        return arrayList;
    }
}

