/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.datavisualization.chart.options.json;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.grapecity.datavisualization.chart.enums.AxisPosition;
import com.grapecity.datavisualization.chart.options.json.JsonConverter;
import com.grapecity.datavisualization.chart.options.json.b;
import java.io.IOException;

public class AxisPositionConverter
extends JsonConverter<AxisPosition> {
    public AxisPosition read(JsonReader jsonReader) throws IOException {
        switch (jsonReader.peek()) {
            case STRING: {
                return AxisPositionConverter.createFromString(jsonReader.nextString());
            }
            case NUMBER: {
                return AxisPositionConverter.createFromNumber(jsonReader.nextDouble());
            }
            case BOOLEAN: {
                return AxisPositionConverter.createFromBoolean(jsonReader.nextBoolean());
            }
        }
        return null;
    }

    public void write(JsonWriter jsonWriter, AxisPosition axisPosition) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static AxisPosition createFromBoolean(boolean bl2) {
        if (bl2) {
            return null;
        }
        return AxisPosition.None;
    }

    public static AxisPosition createFromNumber(double d2) {
        try {
            AxisPosition axisPosition = b.a(AxisPosition.class, (int)d2);
            return axisPosition;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static AxisPosition createFromString(String string) {
        try {
            AxisPosition axisPosition = AxisPosition.valueOf(string);
            return axisPosition;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

