/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.datavisualization.chart.options.json;

import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.grapecity.datavisualization.chart.options.json.JsonConverter;
import java.io.IOException;

public class ColorAngleConverter
extends JsonConverter<Double> {
    public Double read(JsonReader jsonReader) throws IOException {
        double d2 = Double.NaN;
        switch (jsonReader.peek()) {
            case STRING: {
                d2 = ColorAngleConverter.createFromString(jsonReader.nextString());
                break;
            }
            case NUMBER: {
                d2 = jsonReader.nextDouble();
                break;
            }
        }
        return d2;
    }

    public void write(JsonWriter jsonWriter, Double d2) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static double create(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            if (jsonElement.getAsJsonPrimitive().isNumber()) {
                return jsonElement.getAsDouble();
            }
            if (jsonElement.getAsJsonPrimitive().isString()) {
                return ColorAngleConverter.createFromString(jsonElement.getAsString());
            }
        }
        return Double.NaN;
    }

    public static double createFromString(String string) {
        if (string.equals("ToLeft")) {
            return 270.0;
        }
        if (string.equals("ToRight")) {
            return 90.0;
        }
        if (string.equals("ToTop")) {
            return 360.0;
        }
        if (string.equals("ToBottom")) {
            return 180.0;
        }
        if (string.equals("ToLeftTop")) {
            return 315.0;
        }
        if (string.equals("ToRightTop")) {
            return 45.0;
        }
        if (string.equals("ToLeftBottom")) {
            return 225.0;
        }
        if (string.equals("ToRightBottom")) {
            return 135.0;
        }
        return 0.0;
    }
}

