/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.datavisualization.chart.options.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.grapecity.datavisualization.chart.enums.ColorOptionType;
import com.grapecity.datavisualization.chart.enums.GradientExtentKeyword;
import com.grapecity.datavisualization.chart.enums.GradientPositionKeyword;
import com.grapecity.datavisualization.chart.options.CssColorOption;
import com.grapecity.datavisualization.chart.options.GradientPositionOption;
import com.grapecity.datavisualization.chart.options.IColorOption;
import com.grapecity.datavisualization.chart.options.IColorStopOption;
import com.grapecity.datavisualization.chart.options.IGradientPositionOption;
import com.grapecity.datavisualization.chart.options.ILinearGradientOption;
import com.grapecity.datavisualization.chart.options.IRadialGradientOption;
import com.grapecity.datavisualization.chart.options.LinearGradientOption;
import com.grapecity.datavisualization.chart.options.PatternOption;
import com.grapecity.datavisualization.chart.options.RadialGradientOption;
import com.grapecity.datavisualization.chart.options.json.ColorAngleConverter;
import com.grapecity.datavisualization.chart.options.json.JsonConverter;
import com.grapecity.datavisualization.chart.options.json.OptionSerializer;
import com.grapecity.datavisualization.chart.options.json.b;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColorOptionConverter
extends JsonConverter<IColorOption> {
    public IColorOption read(JsonReader jsonReader) throws IOException {
        IColorOption iColorOption = null;
        switch (jsonReader.peek()) {
            case BEGIN_OBJECT: {
                iColorOption = ColorOptionConverter.a(b.a(jsonReader));
                break;
            }
            case STRING: {
                iColorOption = ColorOptionConverter.createFromString(jsonReader.nextString());
                break;
            }
        }
        return iColorOption;
    }

    public void write(JsonWriter jsonWriter, IColorOption iColorOption) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static IColorOption create(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            return ColorOptionConverter.a((JsonElement)jsonElement.getAsJsonObject());
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
            return ColorOptionConverter.createFromString(jsonElement.getAsString());
        }
        return null;
    }

    private static IColorOption a(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            ColorOptionType colorOptionType;
            JsonElement jsonElement2 = b.a("type", jsonElement);
            ColorOptionType colorOptionType2 = colorOptionType = jsonElement2 == null ? null : b.a(ColorOptionType.class, jsonElement2);
            if (colorOptionType != null) {
                switch (colorOptionType) {
                    case Linear: {
                        return new LinearGradientOption(jsonElement);
                    }
                    case Radial: {
                        return new RadialGradientOption(jsonElement);
                    }
                    case Pattern: {
                        return new PatternOption(jsonElement);
                    }
                    case CssColor: {
                        return new CssColorOption(jsonElement);
                    }
                }
                return new CssColorOption(jsonElement);
            }
        }
        return null;
    }

    public static IColorOption createFromString(String string) {
        if (string != null) {
            string = string.trim();
        }
        if (string.equals("") || string == null) {
            return null;
        }
        ILinearGradientOption iLinearGradientOption = ColorOptionConverter.a(string);
        if (iLinearGradientOption != null) {
            return iLinearGradientOption;
        }
        IRadialGradientOption iRadialGradientOption = ColorOptionConverter.b(string);
        if (iRadialGradientOption != null) {
            return iRadialGradientOption;
        }
        CssColorOption cssColorOption = new CssColorOption();
        cssColorOption.setColor(string);
        return cssColorOption;
    }

    private static ILinearGradientOption a(String string) {
        Object object;
        JsonParser jsonParser = new JsonParser();
        Pattern pattern = Pattern.compile("^\\s*(\\w*-\\w*)\\((.*)\\)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return null;
        }
        if (!matcher.group(1).equals("linear-gradient")) {
            return null;
        }
        String string2 = matcher.group(2);
        LinearGradientOption linearGradientOption = new LinearGradientOption();
        pattern = Pattern.compile(",(?![^()]*\\))");
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(pattern.split(string2)));
        ArrayList arrayList2 = new ArrayList(arrayList);
        if (arrayList.get(0).substring(0, 2).equals("to")) {
            String string3 = arrayList.get(0).toLowerCase();
            Object object2 = string3.split(" +");
            object = "";
            for (int i2 = 0; i2 < ((String[])object2).length; ++i2) {
                object = (String)object + object2[i2].substring(0, 1).toUpperCase() + object2[i2].substring(1);
            }
            arrayList.set(0, (String)object);
        }
        if (arrayList.get(0).substring(0, 2).equals("To")) {
            linearGradientOption.setAngle(ColorAngleConverter.createFromString(arrayList.get(0)));
            arrayList2 = new ArrayList<String>(arrayList.subList(1, arrayList.size() - 1));
        }
        if (arrayList.get(0).indexOf("deg") == arrayList.get(0).length() - 3) {
            double d2 = Double.parseDouble(arrayList.get(0).substring(0, arrayList.get(0).length() - 3));
            linearGradientOption.setAngle(d2);
            arrayList2 = (ArrayList)arrayList.subList(1, arrayList.size() - 1);
        }
        for (Object object2 : arrayList2) {
            object = OptionSerializer.a(jsonParser.parse("\"" + (String)object2 + "\""), IColorStopOption.class);
            IColorStopOption iColorStopOption = (IColorStopOption)(object instanceof IColorStopOption ? object : null);
            if (iColorStopOption == null || iColorStopOption.getColor() == null || iColorStopOption.getColor().equals("")) continue;
            linearGradientOption.getColorStops().add(iColorStopOption);
        }
        return linearGradientOption;
    }

    private static IRadialGradientOption b(String string) {
        String string2;
        JsonParser jsonParser = new JsonParser();
        Pattern pattern = Pattern.compile("^\\s*(\\w*-\\w*)\\((.*)\\)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return null;
        }
        if (!matcher.group(1).equals("radial-gradient")) {
            return null;
        }
        String string3 = matcher.group(2);
        RadialGradientOption radialGradientOption = new RadialGradientOption();
        pattern = Pattern.compile(",(?![^()]*\\))");
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(pattern.split(string3)));
        String string4 = "\\s*((closest-side|closest-corner|farthest-side|farthest-corner)\\s+)?";
        String string5 = "(at(((\\s+([\\d.]+%|center|((left|right)(?!\\s+(left|right)))|((top|bottom)(?!\\s+(top|bottom))))){1,2})|((\\s+(((left|right)(?!\\s+[\\d.]+%\\s+(left|right))\\s+[\\d.]+%)|((top|bottom)(?!\\s+[\\d.]+%\\s+(top|bottom))\\s+[\\d.]+%))){2}))(?=\\s*\\,))?";
        pattern = Pattern.compile(string4 + string5);
        matcher = pattern.matcher(string3);
        String string6 = matcher.group(2);
        if (string6 != null) {
            if (string6.equals("closest-side")) {
                radialGradientOption.setExtentKeyword(GradientExtentKeyword.ClosestSide);
            } else if (string6.equals("closest-corner")) {
                radialGradientOption.setExtentKeyword(GradientExtentKeyword.ClosestCorner);
            } else if (string6.equals("farthest-side")) {
                radialGradientOption.setExtentKeyword(GradientExtentKeyword.FarthestSide);
            } else if (string6.equals("farthest-corner")) {
                radialGradientOption.setExtentKeyword(GradientExtentKeyword.FarthestCorner);
            }
        }
        if ((string2 = matcher.group(4)) != null) {
            radialGradientOption.setPosition(ColorOptionConverter.c(string2.trim()));
        }
        for (String string7 : arrayList) {
            Object object = OptionSerializer.a(jsonParser.parse("\"" + string7.trim() + "\""), IColorStopOption.class);
            IColorStopOption iColorStopOption = (IColorStopOption)(object instanceof IColorStopOption ? object : null);
            if (iColorStopOption == null || iColorStopOption.getColor() == null || iColorStopOption.getColor().equals("")) continue;
            radialGradientOption.getColorStops().add(iColorStopOption);
        }
        return radialGradientOption;
    }

    private static ArrayList<IGradientPositionOption> c(String string) {
        GradientPositionOption gradientPositionOption = new GradientPositionOption();
        gradientPositionOption.setKeyword(GradientPositionKeyword.Left);
        gradientPositionOption.setOffset(0.5);
        GradientPositionOption gradientPositionOption2 = new GradientPositionOption();
        gradientPositionOption2.setKeyword(GradientPositionKeyword.Top);
        gradientPositionOption2.setOffset(0.5);
        ArrayList<IGradientPositionOption> arrayList = new ArrayList<IGradientPositionOption>();
        if (string.length() == 0) {
            arrayList.add(gradientPositionOption);
            arrayList.add(gradientPositionOption2);
            return arrayList;
        }
        String[] stringArray = Pattern.compile("\\s+").split(Pattern.quote(string.toString()), -1);
        double d2 = stringArray.length;
        int n2 = 0;
        while ((double)n2 < d2) {
            String string2 = stringArray[n2];
            if (string2.indexOf("%") == string2.length() - 1) {
                string2 = string2.substring(0, string2.length() - 1);
                double d3 = Double.parseDouble(string2) / 100.0;
                if (d2 == 1.0 || n2 == 0) {
                    gradientPositionOption.setKeyword(GradientPositionKeyword.Left);
                    gradientPositionOption.setOffset(d3);
                } else if (d2 == 2.0 && n2 == 1) {
                    if (stringArray[n2 - 1].equals("top") || stringArray[n2 - 1].equals("bottom")) {
                        gradientPositionOption.setOffset(d3);
                    } else {
                        gradientPositionOption2.setOffset(d3);
                    }
                } else if (d2 == 4.0) {
                    if (stringArray[n2 - 1].equals("left") || stringArray[n2 - 1].equals("right")) {
                        gradientPositionOption.setOffset(d3);
                    }
                    if (stringArray[n2 - 1].equals("top") || stringArray[n2 - 1].equals("bottom")) {
                        gradientPositionOption2.setOffset(d3);
                    }
                }
            }
            if (string2.equals("top")) {
                gradientPositionOption2.setKeyword(GradientPositionKeyword.Top);
                gradientPositionOption2.setOffset(0.0);
            } else if (string2.equals("bottom")) {
                gradientPositionOption2.setKeyword(GradientPositionKeyword.Bottom);
                gradientPositionOption2.setOffset(0.0);
            } else if (string2.equals("left")) {
                gradientPositionOption.setKeyword(GradientPositionKeyword.Left);
                gradientPositionOption.setOffset(0.0);
            } else if (string2.equals("right")) {
                gradientPositionOption.setKeyword(GradientPositionKeyword.Right);
                gradientPositionOption.setOffset(0.0);
            }
            ++n2;
        }
        arrayList.add(gradientPositionOption);
        arrayList.add(gradientPositionOption2);
        return arrayList;
    }
}

