/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.datavisualization.chart.options.json;

import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.grapecity.datavisualization.chart.enums.ConcatType;
import com.grapecity.datavisualization.chart.options.ConcatOption;
import com.grapecity.datavisualization.chart.options.IConcatOption;
import com.grapecity.datavisualization.chart.options.json.JsonConverter;
import com.grapecity.datavisualization.chart.options.json.b;
import java.io.IOException;
import java.util.ArrayList;

public class ConcatOptionConverter
extends JsonConverter<IConcatOption> {
    public IConcatOption read(JsonReader jsonReader) throws IOException {
        IConcatOption iConcatOption = null;
        switch (jsonReader.peek()) {
            case STRING: {
                iConcatOption = ConcatOptionConverter.createFromString(jsonReader.nextString());
                break;
            }
            case NUMBER: {
                iConcatOption = ConcatOptionConverter.createFromNumber(jsonReader.nextInt());
                break;
            }
            case BEGIN_ARRAY: {
                iConcatOption = ConcatOptionConverter.createFromArray(b.a(jsonReader));
                break;
            }
        }
        return iConcatOption;
    }

    public void write(JsonWriter jsonWriter, IConcatOption iConcatOption) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static IConcatOption create(JsonElement jsonElement) {
        if (jsonElement.isJsonArray()) {
            return ConcatOptionConverter.createFromArray((JsonElement)jsonElement.getAsJsonArray());
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isNumber()) {
            return ConcatOptionConverter.createFromNumber(jsonElement.getAsDouble());
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
            return ConcatOptionConverter.createFromString(jsonElement.getAsString());
        }
        return null;
    }

    public static IConcatOption createFromNumber(double d2) {
        for (ConcatType concatType : ConcatType.values()) {
            if (concatType.value() != (int)d2) continue;
            ConcatOption concatOption = new ConcatOption();
            concatOption.setType(concatType);
            return concatOption;
        }
        return null;
    }

    public static IConcatOption createFromString(String string) {
        try {
            ConcatType concatType = ConcatType.valueOf(string);
            ConcatOption concatOption = new ConcatOption();
            concatOption.setType(concatType);
            return concatOption;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IConcatOption createFromArray(JsonElement jsonElement) {
        if (jsonElement.isJsonArray()) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ConcatOption concatOption = new ConcatOption();
            for (JsonElement jsonElement2 : jsonElement.getAsJsonArray()) {
                arrayList.add(jsonElement2.getAsInt());
            }
            concatOption.setCustomArray(arrayList);
            return concatOption;
        }
        return null;
    }
}

