/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.datavisualization.chart.options.json;

import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.grapecity.datavisualization.chart.options.DataValueType;
import com.grapecity.datavisualization.chart.options.json.JsonConverter;
import com.grapecity.datavisualization.chart.options.json.b;
import java.io.IOException;
import java.util.ArrayList;

public class DataValueTypeArrayConverter
extends JsonConverter<ArrayList<DataValueType>> {
    public ArrayList<DataValueType> read(JsonReader jsonReader) throws IOException {
        ArrayList<DataValueType> arrayList = new ArrayList<DataValueType>();
        switch (jsonReader.peek()) {
            case BEGIN_ARRAY: {
                arrayList = DataValueTypeArrayConverter.a(b.a(jsonReader));
                break;
            }
            case NUMBER: {
                arrayList = DataValueTypeArrayConverter.CreateFromNumber(jsonReader.nextDouble());
                break;
            }
            case STRING: {
                arrayList = DataValueTypeArrayConverter.createFromString(jsonReader.nextString());
                break;
            }
            case BOOLEAN: {
                arrayList = DataValueTypeArrayConverter.CreateFromBoolean(jsonReader.nextBoolean());
                break;
            }
        }
        return arrayList;
    }

    public void write(JsonWriter jsonWriter, ArrayList<DataValueType> arrayList) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static ArrayList<DataValueType> createFromString(String string) {
        ArrayList<DataValueType> arrayList = new ArrayList<DataValueType>();
        arrayList.add(new DataValueType(string));
        return arrayList;
    }

    public static ArrayList<DataValueType> CreateFromNumber(double d2) {
        ArrayList<DataValueType> arrayList = new ArrayList<DataValueType>();
        arrayList.add(new DataValueType(d2));
        return arrayList;
    }

    public static ArrayList<DataValueType> CreateFromBoolean(boolean bl2) {
        ArrayList<DataValueType> arrayList = new ArrayList<DataValueType>();
        arrayList.add(new DataValueType(bl2));
        return arrayList;
    }

    private static ArrayList<DataValueType> a(JsonElement jsonElement) {
        ArrayList<DataValueType> arrayList = new ArrayList<DataValueType>();
        for (JsonElement jsonElement2 : jsonElement.getAsJsonArray()) {
            if (jsonElement2.getAsJsonPrimitive().isNumber()) {
                arrayList.add(new DataValueType(jsonElement2.getAsDouble()));
                continue;
            }
            if (jsonElement2.getAsJsonPrimitive().isString()) {
                arrayList.add(new DataValueType(jsonElement2.getAsString()));
                continue;
            }
            if (jsonElement2.getAsJsonPrimitive().isBoolean()) {
                arrayList.add(new DataValueType(jsonElement2.getAsBoolean()));
                continue;
            }
            if (!jsonElement2.isJsonNull()) continue;
            arrayList.add(null);
        }
        return arrayList;
    }
}

