/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.datavisualization.chart.options.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.grapecity.datavisualization.chart.options.DataValueType;
import com.grapecity.datavisualization.chart.options.json.JsonConverter;
import java.io.IOException;

public class DataValueTypeConverter
extends JsonConverter<DataValueType> {
    public DataValueType read(JsonReader jsonReader) throws IOException {
        DataValueType dataValueType = null;
        switch (jsonReader.peek()) {
            case STRING: {
                dataValueType = DataValueTypeConverter.createFromString(jsonReader.nextString());
                break;
            }
            case NUMBER: {
                dataValueType = DataValueTypeConverter.createFromNumber(jsonReader.nextDouble());
                break;
            }
            case BOOLEAN: {
                dataValueType = DataValueTypeConverter.createFromBoolean(jsonReader.nextBoolean());
                break;
            }
        }
        return dataValueType;
    }

    public void write(JsonWriter jsonWriter, DataValueType dataValueType) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static DataValueType create(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
            if (jsonPrimitive.isBoolean()) {
                return DataValueTypeConverter.createFromBoolean(jsonPrimitive.getAsBoolean());
            }
            if (jsonPrimitive.isString()) {
                return DataValueTypeConverter.createFromString(jsonPrimitive.getAsString());
            }
            if (jsonPrimitive.isNumber()) {
                return DataValueTypeConverter.createFromNumber(jsonPrimitive.getAsDouble());
            }
        }
        return null;
    }

    public static DataValueType createFromNumber(double d2) {
        return new DataValueType(d2);
    }

    public static DataValueType createFromString(String string) {
        return new DataValueType(string);
    }

    public static DataValueType createFromBoolean(boolean bl2) {
        return new DataValueType(bl2);
    }
}

