/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.datavisualization.chart.options.json;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.grapecity.datavisualization.chart.core.utilities.d;
import com.grapecity.datavisualization.chart.enums.FontWeight;
import com.grapecity.datavisualization.chart.options.json.JsonConverter;
import java.io.IOException;

public class FontWeightConverter
extends JsonConverter<String> {
    private static final int a = 50;
    private static final int b = 950;

    public String read(JsonReader jsonReader) throws IOException {
        String string = null;
        switch (jsonReader.peek()) {
            case STRING: {
                string = jsonReader.nextString();
                break;
            }
            case NUMBER: {
                string = FontWeightConverter.createFromNumber(jsonReader.nextDouble());
                break;
            }
        }
        return string;
    }

    public void write(JsonWriter jsonWriter, String string) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static String createFromNumber(double d2) {
        FontWeight fontWeight = d.a(FontWeight.class, (int)d2);
        if (fontWeight != null) {
            return fontWeight.toString();
        }
        return String.valueOf((int)d2);
    }

    public static boolean IsValidFontWeight(String string) {
        if (string == null) {
            return true;
        }
        try {
            FontWeight.valueOf(string);
            return true;
        }
        catch (Exception exception) {
            try {
                double d2 = Double.parseDouble(string);
                if (50.0 < d2 && d2 < 950.0) {
                    return true;
                }
            }
            catch (Exception exception2) {
                return false;
            }
            return false;
        }
    }
}

