/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.datavisualization.chart.options.json;

import com.google.gson.JsonElement;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.grapecity.datavisualization.chart.core.common.errors.ErrorCode;
import com.grapecity.datavisualization.chart.core.core._options.a;
import com.grapecity.datavisualization.chart.core.core.models._dataSource.h;
import com.grapecity.datavisualization.chart.enums.Palette;
import com.grapecity.datavisualization.chart.enums.PaletteItemType;
import com.grapecity.datavisualization.chart.options.CssColorOption;
import com.grapecity.datavisualization.chart.options.DataValueType;
import com.grapecity.datavisualization.chart.options.IColorOption;
import com.grapecity.datavisualization.chart.options.IPaletteItemOption;
import com.grapecity.datavisualization.chart.options.PaletteItemOption;
import com.grapecity.datavisualization.chart.options.Palettes;
import com.grapecity.datavisualization.chart.options.json.ColorOptionConverter;
import com.grapecity.datavisualization.chart.options.json.JsonConverter;
import com.grapecity.datavisualization.chart.options.json.b;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class PaletteItemOptionsConverter
extends JsonConverter<ArrayList<IPaletteItemOption>> {
    public ArrayList<IPaletteItemOption> read(JsonReader jsonReader) throws IOException {
        ArrayList<IPaletteItemOption> arrayList = null;
        switch (jsonReader.peek()) {
            case STRING: {
                arrayList = PaletteItemOptionsConverter.createFromString(jsonReader.nextString());
                break;
            }
            case NUMBER: {
                arrayList = PaletteItemOptionsConverter.createFromNumber(jsonReader.nextInt());
                break;
            }
            case BEGIN_ARRAY: {
                arrayList = PaletteItemOptionsConverter.createFromArray(b.a(jsonReader));
                break;
            }
        }
        return arrayList;
    }

    public void write(JsonWriter jsonWriter, ArrayList<IPaletteItemOption> arrayList) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static ArrayList<IPaletteItemOption> create(JsonElement jsonElement) {
        if (jsonElement.isJsonArray()) {
            return PaletteItemOptionsConverter.createFromArray((JsonElement)jsonElement.getAsJsonArray());
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isNumber()) {
            return PaletteItemOptionsConverter.createFromNumber(jsonElement.getAsInt());
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
            return PaletteItemOptionsConverter.createFromString(jsonElement.getAsString());
        }
        return null;
    }

    public static ArrayList<IPaletteItemOption> createFromNumber(double d2) {
        for (Palette palette : Palette.values()) {
            if ((double)palette.value() != d2) continue;
            return PaletteItemOptionsConverter.a(palette);
        }
        return null;
    }

    public static ArrayList<IPaletteItemOption> createFromString(String string) {
        try {
            Palette palette = Palette.valueOf(string);
            return PaletteItemOptionsConverter.a(palette);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ArrayList<IPaletteItemOption> createFromArray(JsonElement jsonElement) {
        if (jsonElement.isJsonArray()) {
            IPaletteItemOption iPaletteItemOption;
            ArrayList<IPaletteItemOption> arrayList = new ArrayList<IPaletteItemOption>();
            boolean bl2 = false;
            for (Object object : jsonElement.getAsJsonArray()) {
                iPaletteItemOption = PaletteItemOptionsConverter.a((JsonElement)object);
                if (iPaletteItemOption == null) continue;
                if (iPaletteItemOption.getType() == PaletteItemType.Index) {
                    bl2 = true;
                }
                if (PaletteItemOptionsConverter.a(iPaletteItemOption, arrayList)) continue;
                arrayList.add(iPaletteItemOption);
            }
            if (!bl2) {
                Object object;
                ArrayList<IPaletteItemOption> arrayList2 = PaletteItemOptionsConverter.a(Palette.Office);
                object = arrayList2.iterator();
                while (object.hasNext()) {
                    iPaletteItemOption = (IPaletteItemOption)object.next();
                    arrayList.add(iPaletteItemOption);
                }
            }
            return arrayList;
        }
        return null;
    }

    private static IPaletteItemOption a(JsonElement jsonElement) {
        IColorOption iColorOption;
        if (jsonElement.isJsonObject()) {
            JsonElement jsonElement2 = b.a("color", jsonElement);
            JsonElement jsonElement3 = b.a("type", jsonElement);
            JsonElement jsonElement4 = b.a("data", jsonElement);
            if (jsonElement3 != null) {
                IColorOption iColorOption2;
                PaletteItemType paletteItemType = b.a(PaletteItemType.class, jsonElement3);
                if (paletteItemType == PaletteItemType.Data) {
                    iColorOption2 = PaletteItemOptionsConverter.c(jsonElement2);
                    if (iColorOption2 != null) {
                        PaletteItemOption paletteItemOption = new PaletteItemOption();
                        paletteItemOption.setType(PaletteItemType.Data);
                        paletteItemOption.setData(PaletteItemOptionsConverter.b(jsonElement4));
                        paletteItemOption.setColor(iColorOption2);
                        return paletteItemOption;
                    }
                } else if (paletteItemType == PaletteItemType.Index && (iColorOption2 = PaletteItemOptionsConverter.c(jsonElement2)) != null) {
                    PaletteItemOption paletteItemOption = new PaletteItemOption();
                    paletteItemOption.setType(PaletteItemType.Index);
                    paletteItemOption.setColor(iColorOption2);
                    return paletteItemOption;
                }
                if ((iColorOption2 = PaletteItemOptionsConverter.c(jsonElement)) != null) {
                    PaletteItemOption paletteItemOption = new PaletteItemOption();
                    paletteItemOption.setType(PaletteItemType.Index);
                    paletteItemOption.setColor(iColorOption2);
                    return paletteItemOption;
                }
            } else if (jsonElement4 != null) {
                IColorOption iColorOption3 = PaletteItemOptionsConverter.c(jsonElement2);
                if (iColorOption3 != null) {
                    PaletteItemOption paletteItemOption = new PaletteItemOption();
                    paletteItemOption.setType(PaletteItemType.Data);
                    paletteItemOption.setData(PaletteItemOptionsConverter.b(jsonElement4));
                    paletteItemOption.setColor(iColorOption3);
                    return paletteItemOption;
                }
            } else {
                IColorOption iColorOption4 = PaletteItemOptionsConverter.c(jsonElement2);
                if (iColorOption4 != null) {
                    PaletteItemOption paletteItemOption = new PaletteItemOption();
                    paletteItemOption.setType(PaletteItemType.Index);
                    paletteItemOption.setColor(iColorOption4);
                    return paletteItemOption;
                }
            }
        } else if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString() && (iColorOption = PaletteItemOptionsConverter.c(jsonElement)) != null) {
            PaletteItemOption paletteItemOption = new PaletteItemOption();
            paletteItemOption.setType(PaletteItemType.Index);
            paletteItemOption.setColor(iColorOption);
            return paletteItemOption;
        }
        throw new a(ErrorCode.UnexpectedValue, jsonElement);
    }

    private static boolean a(IPaletteItemOption iPaletteItemOption, ArrayList<IPaletteItemOption> arrayList) {
        if (iPaletteItemOption.getType() == PaletteItemType.Index) {
            return false;
        }
        for (IPaletteItemOption iPaletteItemOption2 : arrayList) {
            if (iPaletteItemOption2.getType() != PaletteItemType.Data) continue;
            if (iPaletteItemOption2.getData() == null) {
                return iPaletteItemOption.getData() == null;
            }
            if (!iPaletteItemOption2.getData().equals(iPaletteItemOption.getData())) continue;
            return true;
        }
        return false;
    }

    private static DataValueType b(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isBoolean()) {
            return h.a(jsonElement.getAsBoolean());
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
            return h.a(jsonElement.getAsString());
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isNumber()) {
            return h.a(jsonElement.getAsDouble());
        }
        return null;
    }

    private static IColorOption c(JsonElement jsonElement) {
        if (jsonElement != null) {
            ColorOptionConverter colorOptionConverter = new ColorOptionConverter();
            try {
                return colorOptionConverter.read((JsonReader)new JsonTreeReader(jsonElement));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static ArrayList<IPaletteItemOption> a(Palette palette) {
        try {
            String[] stringArray;
            Field field = Palettes.class.getField(palette.toString());
            Object object = field.get(null);
            String[] stringArray2 = field == null ? null : (stringArray = (String[])(object instanceof String[] ? object : null));
            if (stringArray != null) {
                ArrayList<IPaletteItemOption> arrayList = new ArrayList<IPaletteItemOption>();
                for (String string : stringArray) {
                    PaletteItemOption paletteItemOption = new PaletteItemOption();
                    CssColorOption cssColorOption = new CssColorOption();
                    cssColorOption.setColor(string);
                    paletteItemOption.setColor(cssColorOption);
                    arrayList.add(paletteItemOption);
                }
                return arrayList;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

