/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.datavisualization.chart.options.json;

import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.grapecity.datavisualization.chart.options.IStrokeWidthOption;
import com.grapecity.datavisualization.chart.options.StrokeWidthOption;
import com.grapecity.datavisualization.chart.options.json.JsonConverter;
import com.grapecity.datavisualization.chart.options.json.b;
import java.io.IOException;

public class StrokeWidthOptionConverter
extends JsonConverter<IStrokeWidthOption> {
    public IStrokeWidthOption read(JsonReader jsonReader) throws IOException {
        IStrokeWidthOption iStrokeWidthOption = null;
        switch (jsonReader.peek()) {
            case STRING: {
                iStrokeWidthOption = StrokeWidthOptionConverter.createFromString(jsonReader.nextString());
                break;
            }
            case NUMBER: {
                iStrokeWidthOption = StrokeWidthOptionConverter.createFromNumber(jsonReader.nextDouble());
                break;
            }
            case BEGIN_OBJECT: {
                iStrokeWidthOption = StrokeWidthOptionConverter.create(b.a(jsonReader));
                break;
            }
        }
        return iStrokeWidthOption;
    }

    public void write(JsonWriter jsonWriter, IStrokeWidthOption iStrokeWidthOption) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static IStrokeWidthOption create(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            return StrokeWidthOptionConverter.a((JsonElement)jsonElement.getAsJsonObject());
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isNumber()) {
            return StrokeWidthOptionConverter.createFromNumber(jsonElement.getAsDouble());
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
            return StrokeWidthOptionConverter.createFromString(jsonElement.getAsString());
        }
        return null;
    }

    private static IStrokeWidthOption a(JsonElement jsonElement) {
        return new StrokeWidthOption(jsonElement);
    }

    public static IStrokeWidthOption createFromNumber(double d2) {
        StrokeWidthOption strokeWidthOption = new StrokeWidthOption();
        strokeWidthOption.setTop(d2);
        strokeWidthOption.setBottom(d2);
        strokeWidthOption.setRight(d2);
        strokeWidthOption.setLeft(d2);
        return strokeWidthOption;
    }

    public static IStrokeWidthOption createFromString(String string) {
        double d2;
        string = string.replace("px", "");
        StrokeWidthOption strokeWidthOption = new StrokeWidthOption();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String[] stringArray = string.split(",+");
        if (stringArray.length >= 4) {
            string2 = stringArray[0];
            string3 = stringArray[1];
            string4 = stringArray[2];
            string5 = stringArray[3];
        } else if (stringArray.length >= 3) {
            string2 = stringArray[0];
            string5 = string3 = stringArray[1];
            string4 = stringArray[2];
        } else if (stringArray.length >= 2) {
            string2 = string4 = stringArray[0];
            string5 = string3 = stringArray[1];
        } else if (stringArray.length >= 1) {
            string5 = string3 = stringArray[0];
            string4 = string3;
            string2 = string3;
        }
        if (!b.a(string2)) {
            try {
                d2 = Double.parseDouble(string2);
                strokeWidthOption.setTop(d2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!b.a(string3)) {
            try {
                d2 = Double.parseDouble(string3);
                strokeWidthOption.setRight(d2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!b.a(string4)) {
            try {
                double d3 = Double.parseDouble(string4);
                strokeWidthOption.setBottom(d3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!b.a(string5)) {
            try {
                double d4 = Double.parseDouble(string5);
                strokeWidthOption.setLeft(d4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return strokeWidthOption;
    }
}

