/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.datavisualization.chart.options.json;

import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.grapecity.datavisualization.chart.enums.TextDecoration;
import com.grapecity.datavisualization.chart.options.ITextDecorationOption;
import com.grapecity.datavisualization.chart.options.TextDecorationOption;
import com.grapecity.datavisualization.chart.options.json.JsonConverter;
import com.grapecity.datavisualization.chart.options.json.b;
import java.io.IOException;

public class TextDecorationOptionConverter
extends JsonConverter<ITextDecorationOption> {
    public ITextDecorationOption read(JsonReader jsonReader) throws IOException {
        ITextDecorationOption iTextDecorationOption = null;
        switch (jsonReader.peek()) {
            case STRING: {
                iTextDecorationOption = TextDecorationOptionConverter.createFromString(jsonReader.nextString());
                break;
            }
            case NUMBER: {
                iTextDecorationOption = TextDecorationOptionConverter.createFromNumber(jsonReader.nextDouble());
                break;
            }
            case BEGIN_OBJECT: {
                iTextDecorationOption = TextDecorationOptionConverter.create(b.a(jsonReader));
                break;
            }
        }
        return iTextDecorationOption;
    }

    public void write(JsonWriter jsonWriter, ITextDecorationOption iTextDecorationOption) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static ITextDecorationOption create(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            return TextDecorationOptionConverter.a((JsonElement)jsonElement.getAsJsonObject());
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
            return TextDecorationOptionConverter.createFromString(jsonElement.getAsString());
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isNumber()) {
            return TextDecorationOptionConverter.createFromNumber(jsonElement.getAsDouble());
        }
        return null;
    }

    private static ITextDecorationOption a(JsonElement jsonElement) {
        return new TextDecorationOption(jsonElement);
    }

    public static ITextDecorationOption createFromString(String string) {
        String[] stringArray;
        TextDecorationOption textDecorationOption = new TextDecorationOption();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (String string2 : stringArray = string.split(",+")) {
            String string3 = string2.trim();
            if (string3.equals("Overline")) {
                bl2 = true;
                continue;
            }
            if (string3.equals("LineThrough")) {
                bl3 = true;
                continue;
            }
            if (!string3.equals("Underline")) continue;
            bl4 = true;
        }
        textDecorationOption.setOverline(bl2);
        textDecorationOption.setLineThrough(bl3);
        textDecorationOption.setUnderline(bl4);
        return textDecorationOption;
    }

    public static ITextDecorationOption createFromNumber(double d2) {
        TextDecorationOption textDecorationOption = new TextDecorationOption();
        int n2 = (int)d2;
        textDecorationOption.setOverline((n2 & TextDecoration.Overline.value()) != 0);
        textDecorationOption.setLineThrough((n2 & TextDecoration.LineThrough.value()) != 0);
        textDecorationOption.setUnderline((n2 & TextDecoration.Underline.value()) != 0);
        return textDecorationOption;
    }
}

