/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.datavisualization.chart.options.json;

import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.grapecity.datavisualization.chart.core.common.errors.ErrorCode;
import com.grapecity.datavisualization.chart.core.core._options.a;
import com.grapecity.datavisualization.chart.enums.TransformType;
import com.grapecity.datavisualization.chart.options.AggregateTransformOption;
import com.grapecity.datavisualization.chart.options.BinTransformOption;
import com.grapecity.datavisualization.chart.options.CalculateTransformOption;
import com.grapecity.datavisualization.chart.options.ITransformOption;
import com.grapecity.datavisualization.chart.options.UnpivotTransformOption;
import com.grapecity.datavisualization.chart.options.json.JsonConverter;
import com.grapecity.datavisualization.chart.options.json.b;
import java.io.IOException;

public class TransformOptionConverter
extends JsonConverter<ITransformOption> {
    public ITransformOption read(JsonReader jsonReader) throws IOException {
        switch (jsonReader.peek()) {
            case BEGIN_OBJECT: {
                return TransformOptionConverter.a(b.a(jsonReader));
            }
        }
        return null;
    }

    public void write(JsonWriter jsonWriter, ITransformOption iTransformOption) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static ITransformOption create(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            return TransformOptionConverter.a((JsonElement)jsonElement.getAsJsonObject());
        }
        return null;
    }

    private static ITransformOption a(JsonElement jsonElement) {
        JsonElement jsonElement2 = b.a("type", jsonElement);
        if (jsonElement2 != null) {
            String string = jsonElement2.getAsString();
            TransformType transformType = TransformType.valueOf(string);
            switch (transformType) {
                case Aggregate: {
                    return new AggregateTransformOption(jsonElement);
                }
                case Bin: {
                    return new BinTransformOption(jsonElement);
                }
                case Calculate: {
                    return new CalculateTransformOption(jsonElement);
                }
                case Unpivot: {
                    return new UnpivotTransformOption(jsonElement);
                }
            }
        } else {
            if (b.a("aggregate", jsonElement) != null) {
                AggregateTransformOption aggregateTransformOption = new AggregateTransformOption(jsonElement);
                aggregateTransformOption.setType(TransformType.Aggregate);
                return aggregateTransformOption;
            }
            if (b.a("bin", jsonElement) != null && b.a("field", jsonElement) != null && b.a("outputAs", jsonElement) != null) {
                BinTransformOption binTransformOption = new BinTransformOption(jsonElement);
                binTransformOption.setType(TransformType.Bin);
                return binTransformOption;
            }
            if (b.a("calculate", jsonElement) != null && b.a("outputAs", jsonElement) != null) {
                CalculateTransformOption calculateTransformOption = new CalculateTransformOption(jsonElement);
                calculateTransformOption.setType(TransformType.Calculate);
                return calculateTransformOption;
            }
            if (b.a("category", jsonElement) != null && b.a("valueFieldAs", jsonElement) != null && b.a("outputAs", jsonElement) != null) {
                UnpivotTransformOption unpivotTransformOption = new UnpivotTransformOption(jsonElement);
                unpivotTransformOption.setType(TransformType.Unpivot);
                return unpivotTransformOption;
            }
            return null;
        }
        throw new a(ErrorCode.UnexpectedValue, new Object[0]);
    }
}

