/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.datavisualization.chart.options.json;

import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.grapecity.datavisualization.chart.enums.HeaderFooterWidthOptionType;
import com.grapecity.datavisualization.chart.enums.ValueOptionType;
import com.grapecity.datavisualization.chart.options.IValueOption;
import com.grapecity.datavisualization.chart.options.ValueOption;
import com.grapecity.datavisualization.chart.options.json.JsonConverter;
import com.grapecity.datavisualization.chart.options.json.b;
import java.io.IOException;

public class ValueOptionConverter
extends JsonConverter<IValueOption> {
    public IValueOption read(JsonReader jsonReader) throws IOException {
        IValueOption iValueOption = null;
        switch (jsonReader.peek()) {
            case BEGIN_OBJECT: {
                iValueOption = this.createFromObjectImp(b.a(jsonReader));
                break;
            }
            case NUMBER: {
                iValueOption = this.createFromNumberImp(jsonReader.nextDouble());
                break;
            }
            case STRING: {
                iValueOption = this.createFromStringImp(jsonReader.nextString());
                break;
            }
        }
        return iValueOption;
    }

    public static IValueOption create(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            return ValueOptionConverter.createFromObject(jsonElement);
        }
        if (jsonElement.isJsonPrimitive()) {
            if (jsonElement.getAsJsonPrimitive().isNumber()) {
                return ValueOptionConverter.createFromNumber(jsonElement.getAsDouble());
            }
            if (jsonElement.getAsJsonPrimitive().isString()) {
                return ValueOptionConverter.createFromString(jsonElement.getAsString());
            }
        }
        return null;
    }

    public static IValueOption createFromObject(JsonElement jsonElement) {
        return new ValueOption(jsonElement);
    }

    public static IValueOption createFromNumber(double d2) {
        ValueOption valueOption = new ValueOption();
        valueOption.setType(ValueOptionType.Pixel);
        valueOption.setValue(d2);
        return valueOption;
    }

    public static IValueOption createFromString(String string) {
        ValueOptionType valueOptionType = ValueOptionType.Number;
        String string2 = null;
        if (string.toLowerCase().endsWith("px")) {
            valueOptionType = ValueOptionType.Pixel;
            string2 = string.substring(0, string.length() - 2);
        } else if (string.endsWith("%")) {
            valueOptionType = ValueOptionType.Percentage;
            double d2 = Double.parseDouble(string.substring(0, string.length() - 1));
            if (d2 < 0.0) {
                d2 = 1.0;
            }
            string2 = String.valueOf(d2);
        } else if (string.endsWith("*")) {
            valueOptionType = ValueOptionType.Available;
            string2 = string.substring(0, string.length() - 1);
            if (string2.equals("")) {
                string2 = "1";
            }
        } else {
            try {
                string2 = String.valueOf(HeaderFooterWidthOptionType.valueOf(string).value());
                valueOptionType = ValueOptionType.Enum;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    Double.parseDouble(string);
                    valueOptionType = ValueOptionType.Pixel;
                    string2 = string;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string2 != null && !string2.isEmpty()) {
                ValueOption valueOption = new ValueOption();
                valueOption.setType(valueOptionType);
                valueOption.setValue(Double.parseDouble(string2));
                return valueOption;
            }
        }
        return null;
    }

    public void write(JsonWriter jsonWriter, IValueOption iValueOption) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected IValueOption createFromObjectImp(JsonElement jsonElement) {
        return ValueOptionConverter.createFromObject(jsonElement);
    }

    protected IValueOption createFromStringImp(String string) {
        return ValueOptionConverter.createFromString(string);
    }

    protected IValueOption createFromNumberImp(double d2) {
        return ValueOptionConverter.createFromNumber(d2);
    }
}

