/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.documents.excel;

import com.grapecity.documents.excel.B.Y;
import com.grapecity.documents.excel.B.aF;
import com.grapecity.documents.excel.B.am;
import com.grapecity.documents.excel.B.az;
import com.grapecity.documents.excel.C.R;
import com.grapecity.documents.excel.C.bL;
import com.grapecity.documents.excel.C.bN;
import com.grapecity.documents.excel.C.o;
import com.grapecity.documents.excel.D.O;
import com.grapecity.documents.excel.IRange;
import com.grapecity.documents.excel.IWorkbook;
import com.grapecity.documents.excel.IWorksheet;
import com.grapecity.documents.excel.L;
import com.grapecity.documents.excel.Order;
import com.grapecity.documents.excel.PageContentInfo;
import com.grapecity.documents.excel.PageInfo;
import com.grapecity.documents.excel.PageSettings;
import com.grapecity.documents.excel.PaginationOrientation;
import com.grapecity.documents.excel.PdfSaveOptions;
import com.grapecity.documents.excel.Point;
import com.grapecity.documents.excel.Rectangle;
import com.grapecity.documents.excel.RepeatSetting;
import com.grapecity.documents.excel.Size;
import com.grapecity.documents.excel.Visibility;
import com.grapecity.documents.excel.Workbook;
import com.grapecity.documents.excel.bF;
import com.grapecity.documents.excel.ce;
import com.grapecity.documents.excel.cp;
import com.grapecity.documents.excel.cr;
import com.grapecity.documents.excel.dA;
import com.grapecity.documents.excel.dw;
import com.grapecity.documents.excel.g.av;
import com.grapecity.documents.excel.g.cb;
import com.grapecity.documents.excel.g.q;
import com.grapecity.documents.excel.q.a.e;
import com.grapecity.documents.excel.q.g;
import com.grapecity.documents.excel.q.i;
import com.grapecity.documents.excel.u.b;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

@Y
public class PrintManager {
    private Log a = LogFactory.getLog(PrintManager.class);
    private HashMap<IWorkbook, dw> b = new HashMap();
    private ArrayList<e> c = new ArrayList();

    protected void finalize() throws Throwable {
        if (this.c.size() > 0) {
            for (e e2 : this.c) {
                if (e2 == null) continue;
                e2.b();
            }
        }
        super.finalize();
    }

    @Y
    public final void saveWorkbooksToPDF(OutputStream outputStream, List<IWorkbook> list) {
        List<PageInfo> list2 = this.paginate(list);
        this.savePageInfosToPDF(outputStream, list2);
    }

    @Y
    public final void saveWorkbooksToPDF(OutputStream outputStream, List<IWorkbook> list, PdfSaveOptions pdfSaveOptions) {
        List<PageInfo> list2 = this.paginate(list);
        this.savePageInfosToPDF(outputStream, list2, pdfSaveOptions);
    }

    @Y
    public final void saveWorkbooksToPDF(String string, List<IWorkbook> list) {
        this.saveWorkbooksToPDF(string, list, null);
    }

    @Y
    public final void saveWorkbooksToPDF(String string, List<IWorkbook> list, PdfSaveOptions pdfSaveOptions) {
        if (!cb.g(string)) {
            throw new IllegalArgumentException("Exception_InvalidArgument" + string);
        }
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string);
            fileOutputStream = new FileOutputStream(file);
            this.saveWorkbooksToPDF(fileOutputStream, list, pdfSaveOptions);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException(fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Y
    public final void savePageInfosToPDF(OutputStream outputStream, List<PageInfo> list) {
        i.a(this, outputStream, list);
    }

    @Y
    public final void savePageInfosToPDF(OutputStream outputStream, List<PageInfo> list, PdfSaveOptions pdfSaveOptions) {
        i.a(this, outputStream, list, pdfSaveOptions);
    }

    @Y
    public final void savePageInfosToPDF(String string, List<PageInfo> list) {
        this.savePageInfosToPDF(string, list, null);
    }

    @Y
    public final void savePageInfosToPDF(String string, List<PageInfo> list, PdfSaveOptions pdfSaveOptions) {
        if (!cb.g(string)) {
            throw new IllegalArgumentException("Exception_InvalidArgument" + string);
        }
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string);
            fileOutputStream = new FileOutputStream(file);
            this.savePageInfosToPDF(fileOutputStream, list, pdfSaveOptions);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException(fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Y
    public final List<PageInfo> paginate(List<IWorkbook> list) {
        ArrayList<PageInfo> arrayList = new ArrayList<PageInfo>();
        for (IWorkbook iWorkbook : list) {
            arrayList.addAll(this.paginate(iWorkbook));
        }
        this.updatePageNumberAndPageSettings(arrayList);
        return arrayList;
    }

    @Y
    public final List<PageInfo> paginate(IWorkbook iWorkbook) {
        ArrayList<PageInfo> arrayList = new ArrayList<PageInfo>();
        for (IWorksheet iWorksheet : iWorkbook.getWorksheets()) {
            if (iWorksheet.getVisible() != Visibility.Visible) continue;
            arrayList.addAll(this.paginate(iWorksheet));
        }
        this.updatePageNumberAndPageSettings(arrayList);
        return arrayList;
    }

    @Y
    public final List<PageInfo> paginate(IWorksheet iWorksheet) {
        ArrayList<PageInfo> arrayList = new ArrayList<PageInfo>();
        List<IRange> list = this.a(iWorksheet).d();
        for (IRange iRange : list) {
            arrayList.addAll(this.paginate(iRange));
        }
        this.updatePageNumberAndPageSettings(arrayList);
        return arrayList;
    }

    @Y
    public final List<PageInfo> paginate(IWorksheet iWorksheet, List<IRange> list, List<RepeatSetting> list2) {
        ArrayList<PageInfo> arrayList = new ArrayList<PageInfo>();
        List<IRange> list3 = this.a(iWorksheet).d();
        double d2 = this.a(iWorksheet, list, list2);
        for (IRange iRange : list3) {
            arrayList.addAll(this.a(iRange, d2, list, list2));
        }
        this.updatePageNumberAndPageSettings(arrayList);
        return arrayList;
    }

    @Y
    public final PageContentInfo generatePageContentInfo(IRange iRange, Size size, int n2, int n3, boolean bl2, boolean bl3) {
        return this.a(iRange, size, n2, n3, bl2, bl3, -1.0, -1, -1, -1, -1, -1, -1, -1, -1, 1.0);
    }

    @Y
    public final void updatePageNumberAndPageSettings(List<PageInfo> list) {
        i.a(list);
    }

    @Y
    public final void updatePageNumberAndPageSettings(List<PageInfo> list, int n2, int n3) {
        i.a(list, n2, n3);
    }

    @Y
    public final void appendPage(PDDocument pDDocument, PageInfo pageInfo) {
        this.appendPage(pDDocument, pageInfo, null);
    }

    @Y
    public final void appendPage(PDDocument pDDocument, PageInfo pageInfo, PdfSaveOptions pdfSaveOptions) {
        PageSettings pageSettings = pageInfo.b();
        float f2 = (float)pageSettings.getPaperWidth();
        float f3 = (float)pageSettings.getPaperHeight();
        PDRectangle pDRectangle = new PDRectangle(f2, f3);
        PDPage pDPage = new PDPage(pDRectangle);
        pDDocument.addPage(pDPage);
        this.draw(pDDocument, pDPage, new Rectangle(0.0, 0.0, f2, f3), pageInfo, pdfSaveOptions);
    }

    @Y
    public final void draw(PDDocument pDDocument, PDPage pDPage, List<PageInfo> list, int n2, int n3) {
        this.draw(pDDocument, pDPage, list, n2, n3, Order.OverThenDown);
    }

    @Y
    public final void draw(PDDocument pDDocument, PDPage pDPage, List<PageInfo> list, int n2, int n3, Order order) {
        this.draw(pDDocument, pDPage, list, n2, n3, order, null);
    }

    @Y
    public final void draw(PDDocument pDDocument, PDPage pDPage, List<PageInfo> list, int n2, int n3, Order order, PdfSaveOptions pdfSaveOptions) {
        int n4 = 0;
        float f2 = pDPage.getMediaBox().getWidth() / (float)n3;
        float f3 = pDPage.getMediaBox().getHeight() / (float)n2;
        PDPageContentStream pDPageContentStream = null;
        try {
            pDPageContentStream = new PDPageContentStream(pDDocument, pDPage, PDPageContentStream.AppendMode.APPEND, true);
        }
        catch (IOException iOException) {
            this.a.debug((Object)iOException.getMessage());
        }
        for (PageInfo pageInfo : list) {
            int n5 = 0;
            int n6 = 0;
            if (order == Order.OverThenDown) {
                n5 = n4 % n3;
                n6 = n4 / n3;
            } else {
                n5 = n4 / n2;
                n6 = n4 % n2;
            }
            Rectangle rectangle = new Rectangle((float)n5 * f2, (float)n6 * f3, f2, f3);
            am<e> am2 = new am<e>();
            i.a(this.a(pageInfo.getPageContent().getRange().getWorksheet()), pDDocument, pDPage, pDPageContentStream, rectangle, pageInfo, pdfSaveOptions, am2);
            ++n4;
            this.c.add((e)am2.a);
        }
        if (pDPageContentStream != null) {
            try {
                pDPageContentStream.close();
            }
            catch (IOException iOException) {
                this.a.debug((Object)iOException.getMessage());
            }
        }
    }

    @Y
    public final boolean hasPrintContent(IRange iRange) {
        return this.a(iRange.getWorksheet()).a(iRange);
    }

    @Y
    public final Size getSize(PageContentInfo pageContentInfo) {
        return pageContentInfo.a(this.a(pageContentInfo.getRange().getWorksheet()));
    }

    @Y
    public final Size getSize(IRange iRange) {
        dA dA2 = this.a(iRange.getWorksheet());
        com.grapecity.documents.excel.g.bF bF2 = dA2.c().d(new q(iRange.getRow(), iRange.getColumn(), iRange.getRowCount(), iRange.getColumnCount()));
        bF2.d *= dA2.a().c();
        return new Size(bF2.c, bF2.d);
    }

    public final dw a(IWorkbook iWorkbook) {
        dw dw2 = this.b.get(iWorkbook);
        if (dw2 != null) {
            return dw2;
        }
        dw2 = new dw((Workbook)iWorkbook);
        this.b.put(iWorkbook, dw2);
        return dw2;
    }

    public final dA a(IWorksheet iWorksheet) {
        dw dw2 = this.a(iWorksheet.getWorkbook());
        return dw2.e().a(iWorksheet.getName());
    }

    @Y
    public final List<PageInfo> paginate(IRange iRange) {
        List<PageInfo> list = i.a(this.a(iRange.getWorksheet()), iRange);
        this.updatePageNumberAndPageSettings(list);
        return list;
    }

    private final List<PageInfo> a(IRange iRange, double d2, List<IRange> list, List<RepeatSetting> list2) {
        PageSettings pageSettings = this.a(iRange.getWorksheet(), bF.a);
        double d3 = pageSettings.getPaperWidth() - pageSettings.getLeftMargin() - pageSettings.getRightMargin();
        double d4 = pageSettings.getPaperHeight() - pageSettings.getTopMargin() - pageSettings.getBottomMargin();
        boolean bl2 = true;
        boolean bl3 = true;
        if (iRange.getWorksheet().getPageSetup().getIsPercentScale() || iRange.getWorksheet().getPageSetup().getFitToPagesTall() <= 0) {
            bl2 = false;
        }
        if (iRange.getWorksheet().getPageSetup().getIsPercentScale() || iRange.getWorksheet().getPageSetup().getFitToPagesWide() <= 0) {
            bl3 = false;
        }
        ArrayList<cr> arrayList = this.a(iRange, d4, list, list2, d2, bl2);
        ArrayList<L> arrayList2 = this.b(iRange, d3, list, list2, d2, bl3);
        List<PageInfo> list3 = this.a(arrayList, arrayList2, iRange.getWorksheet().getPageSetup().getOrder());
        this.updatePageNumberAndPageSettings(list3);
        return list3;
    }

    private ArrayList<cr> a(IRange iRange, double d2, List<IRange> list, List<RepeatSetting> list2, double d3, boolean bl2) {
        ArrayList<cr> arrayList = new ArrayList<cr>();
        int n2 = iRange.getRow();
        int n3 = iRange.getLastRow();
        boolean bl3 = false;
        if (iRange.getWorksheet().getPageSetup().getPrintHeadings()) {
            bl3 = true;
        }
        while (true) {
            Object object;
            int n4 = -1;
            int n5 = -1;
            if (list2 != null && !list2.isEmpty()) {
                object = list2.iterator();
                while (object.hasNext()) {
                    RepeatSetting repeatSetting = object.next();
                    if (repeatSetting.getRange().getRow() > n2 || repeatSetting.getRange().getLastRow() < n2) continue;
                    if (n2 > repeatSetting.getTitleRowEnd()) {
                        n4 = repeatSetting.getTitleRowStart();
                        n5 = repeatSetting.getTitleRowEnd();
                        break;
                    }
                    if (n2 <= repeatSetting.getTitleRowStart()) break;
                    n2 = repeatSetting.getTitleRowStart();
                    break;
                }
            }
            if ((object = this.a(iRange, d3, n4, n5, -1, -1, bl3, n2, d2, bl2)) == null) break;
            int n6 = ((cr)object).h;
            int n7 = -1;
            int n8 = -1;
            if (list2 != null && !list2.isEmpty()) {
                for (RepeatSetting repeatSetting : list2) {
                    if (repeatSetting.getRange().getRow() > n6 || repeatSetting.getRange().getLastRow() < n6) continue;
                    if (n6 >= repeatSetting.getTailRowEnd()) break;
                    n7 = repeatSetting.getTailRowStart();
                    n8 = repeatSetting.getTailRowEnd();
                    break;
                }
            }
            if (n7 >= 0 && (object = this.a(iRange, d3, n4, n5, n7, n8, bl3, n2, d2, bl2)) == null) break;
            if (list != null && !list.isEmpty()) {
                n6 = ((cr)object).h;
                for (IRange iRange2 : list) {
                    if (((ce)iRange2).a().get(0).b()) continue;
                    bN bN2 = this.a(iRange.getWorksheet()).c();
                    double d4 = bN2.b().b(iRange2.getRow(), iRange2.getLastRow());
                    if (d2 < d4) {
                        throw new IllegalStateException(com.grapecity.documents.excel.u.b.a("Exception_PDF_KeepTogetherHeightTooLarge"));
                    }
                    if (iRange2.getRow() > n6 || iRange2.getLastRow() <= n6) continue;
                    n6 = iRange2.getRow() - 1;
                }
                ((cr)object).h = n6;
            }
            if (((cr)object).g > ((cr)object).h) {
                throw new IllegalStateException(com.grapecity.documents.excel.u.b.a("Exception_PDF_KeepTogetherAndRepeatHeightTooLarge"));
            }
            arrayList.add((cr)object);
            if (((cr)object).h >= n3) {
                ((cr)object).h = n3;
                break;
            }
            n2 = ((cr)object).h + 1;
        }
        return arrayList;
    }

    private ArrayList<L> b(IRange iRange, double d2, List<IRange> list, List<RepeatSetting> list2, double d3, boolean bl2) {
        Object object;
        int n2;
        ArrayList<L> arrayList = new ArrayList<L>();
        int n3 = iRange.getColumn();
        int n4 = iRange.getLastColumn();
        boolean bl3 = false;
        double d4 = -1.0;
        if (iRange.getWorksheet().getPageSetup().getPrintHeadings()) {
            bl3 = true;
            n2 = Math.max(String.valueOf(iRange.getLastRow()).length(), 3);
            IWorkbook iWorkbook = iRange.getWorksheet().getWorkbook();
            object = iRange.getWorksheet().getWorkbook();
            d4 = ((Workbook)iWorkbook).b(av.b) * (double)n2 + 0.36363636363636365 * ((Workbook)object).n().a((int)0).b.c;
        }
        while (true) {
            n2 = -1;
            int n5 = -1;
            if (list2 != null && !list2.isEmpty()) {
                object = list2.iterator();
                while (object.hasNext()) {
                    RepeatSetting repeatSetting = object.next();
                    if (repeatSetting.getRange().getColumn() > n3 || repeatSetting.getRange().getLastColumn() < n3) continue;
                    if (n3 > repeatSetting.getTitleColumnEnd()) {
                        n2 = repeatSetting.getTitleColumnStart();
                        n5 = repeatSetting.getTitleColumnEnd();
                        break;
                    }
                    if (n3 <= repeatSetting.getTitleColumnStart()) break;
                    n3 = repeatSetting.getTitleColumnStart();
                    break;
                }
            }
            if ((object = this.a(iRange, d3, n2, n5, -1, -1, bl3, d4, n3, d2, bl2)) == null) break;
            int n6 = ((L)object).h;
            int n7 = -1;
            int n8 = -1;
            if (list2 != null && !list2.isEmpty()) {
                for (RepeatSetting repeatSetting : list2) {
                    if (repeatSetting.getRange().getColumn() > n6 || repeatSetting.getRange().getLastColumn() < n6) continue;
                    if (n6 >= repeatSetting.getTailColumnEnd()) break;
                    n7 = repeatSetting.getTailColumnStart();
                    n8 = repeatSetting.getTailColumnEnd();
                    break;
                }
            }
            if (n7 >= 0 && (object = this.a(iRange, d3, n2, n5, n7, n8, bl3, d4, n3, d2, bl2)) == null) break;
            if (list != null && !list.isEmpty()) {
                n6 = ((L)object).h;
                for (IRange iRange2 : list) {
                    if (((ce)iRange2).a().get(0).a()) continue;
                    bN bN2 = this.a(iRange.getWorksheet()).c();
                    double d5 = bN2.c().b(iRange2.getColumn(), iRange2.getLastColumn());
                    if (d2 < d5) {
                        throw new IllegalStateException(com.grapecity.documents.excel.u.b.a("Exception_PDF_KeepTogetherWidthTooLarge"));
                    }
                    if (iRange2.getColumn() > n6 || iRange2.getLastColumn() <= n6) continue;
                    n6 = iRange2.getColumn() - 1;
                }
                ((L)object).h = n6;
            }
            if (((L)object).g > ((L)object).h) {
                throw new IllegalStateException(com.grapecity.documents.excel.u.b.a("Exception_PDF_KeepTogetherAndRepeatWidthTooLarge"));
            }
            arrayList.add((L)object);
            if (((L)object).h >= n4) {
                ((L)object).h = n4;
                break;
            }
            n3 = ((L)object).h + 1;
        }
        return arrayList;
    }

    private final List<cr> a(IRange iRange) {
        return i.a(this.a(iRange.getWorksheet()), ((ce)iRange).b().get(0));
    }

    private final List<cr> a(IRange iRange, double d2, int n2, boolean bl2) {
        dA dA2 = this.a(iRange.getWorksheet());
        boolean bl3 = dA2.b().getPageSetup().getPrintHeadings();
        cp cp2 = dA2.j();
        PageSettings pageSettings = dA2.a(bF.a);
        double d3 = pageSettings.a().d;
        ArrayList<cr> arrayList = this.a(iRange, d2, bl2, d3, bl3, cp2);
        if (n2 <= 0 || arrayList.size() < n2) {
            return arrayList;
        }
        double d4 = 0.0;
        double d5 = d2;
        while (d5 - d4 > 0.1) {
            d2 = (d4 + d5) / 2.0;
            arrayList = this.a(iRange, d2, bl2, d3, bl3, cp2);
            if (arrayList.size() < n2) {
                d4 = d2;
                continue;
            }
            d5 = d2;
        }
        return arrayList;
    }

    private ArrayList<cr> a(IRange iRange, double d2, boolean bl2, double d3, boolean bl3, cp cp2) {
        cr cr2;
        ArrayList<cr> arrayList = new ArrayList<cr>();
        int n2 = iRange.getRow();
        while ((cr2 = this.a(iRange, d2, cp2.a, cp2.b, cp2.c, cp2.d, bl3, n2, d3, bl2, true)) != null) {
            if (cr2.h >= iRange.getLastRow()) {
                cr2.h = iRange.getLastRow();
                arrayList.add(cr2);
                break;
            }
            arrayList.add(cr2);
            n2 = cr2.h + 1;
        }
        return arrayList;
    }

    private final List<L> b(IRange iRange) {
        return i.b(this.a(iRange.getWorksheet()), ((ce)iRange).b().get(0));
    }

    private final List<L> a(IRange iRange, double d2, int n2, double d3, boolean bl2) {
        dA dA2 = this.a(iRange.getWorksheet());
        dA2.b().getPageSetup().getPrintHeadings();
        cp cp2 = dA2.j();
        PageSettings pageSettings = dA2.a(bF.a);
        double d4 = pageSettings.a().c;
        ArrayList<L> arrayList = this.a(iRange, d2, bl2, d4, d3, cp2);
        if (n2 <= 0 || arrayList.size() < n2) {
            return arrayList;
        }
        double d5 = 0.0;
        double d6 = d2;
        while (d6 - d5 > 0.1) {
            d2 = (d5 + d6) / 2.0;
            arrayList = this.a(iRange, d2, bl2, d4, d3, cp2);
            if (arrayList.size() < n2) {
                d5 = d2;
                continue;
            }
            d6 = d2;
        }
        return arrayList;
    }

    private ArrayList<L> a(IRange iRange, double d2, boolean bl2, double d3, double d4, cp cp2) {
        L l2;
        ArrayList<L> arrayList = new ArrayList<L>();
        int n2 = iRange.getColumn();
        while ((l2 = this.a(iRange, d2, cp2.a, cp2.b, cp2.c, cp2.d, d4 > 0.0, d4, n2, d3, bl2, true)) != null) {
            if (l2.h >= iRange.getLastColumn()) {
                l2.h = iRange.getLastColumn();
                arrayList.add(l2);
                break;
            }
            arrayList.add(l2);
            n2 = l2.h + 1;
        }
        return arrayList;
    }

    private final List<PageInfo> a(List<cr> list, List<L> list2, Order order) {
        PageInfo pageInfo;
        int n2;
        int n3;
        ArrayList<PageInfo> arrayList = new ArrayList<PageInfo>();
        q.j();
        q.j();
        if (order == Order.DownThenOver) {
            for (n3 = 0; n3 < list2.size(); ++n3) {
                for (n2 = 0; n2 < list.size(); ++n2) {
                    if (!list2.get((int)n3).b.equals(list.get((int)n2).b)) {
                        throw new IllegalStateException();
                    }
                    pageInfo = new PageInfo();
                    pageInfo.setPageContent(new PageContentInfo(list.get(n2), list2.get(n3)));
                    arrayList.add(pageInfo);
                }
            }
        } else {
            for (n3 = 0; n3 < list.size(); ++n3) {
                for (n2 = 0; n2 < list2.size(); ++n2) {
                    if (!list2.get((int)n2).b.equals(list.get((int)n3).b)) {
                        throw new IllegalStateException();
                    }
                    pageInfo = new PageInfo();
                    pageInfo.setPageContent(new PageContentInfo(list.get(n3), list2.get(n2)));
                    arrayList.add(pageInfo);
                }
            }
        }
        if (arrayList.size() <= 0) {
            return arrayList;
        }
        if (az.a(list.get((int)0).b.getPageSetup().getPrintArea()) && az.a(list.get((int)0).b.getPageSetup().getPrintTitleRows()) && az.a(list.get((int)0).b.getPageSetup().getPrintTitleColumns())) {
            PageInfo pageInfo2;
            while (!arrayList.isEmpty() && !this.a((pageInfo2 = arrayList.get(arrayList.size() - 1)).getPageContent().getRange().getWorksheet()).a(pageInfo2.getPageContent().getRange())) {
                arrayList.remove(arrayList.size() - 1);
            }
        }
        this.updatePageNumberAndPageSettings(arrayList);
        return arrayList;
    }

    @Y
    public final void draw(PDDocument pDDocument, PDPage pDPage, Point point, IRange iRange) {
        Size size = this.getSize(iRange);
        this.draw(pDDocument, pDPage, new Rectangle(point.getX(), point.getY(), (float)size.getWidth(), (float)size.getHeight()), iRange);
    }

    @Y
    public final void draw(PDDocument pDDocument, PDPage pDPage, Point point, IRange iRange, PdfSaveOptions pdfSaveOptions) {
        Size size = this.getSize(iRange);
        this.draw(pDDocument, pDPage, new Rectangle(point.getX(), point.getY(), (float)size.getWidth(), (float)size.getHeight()), iRange, pdfSaveOptions);
    }

    @Y
    private final void draw(PDDocument pDDocument, PDPage pDPage, Point point, PageContentInfo pageContentInfo) {
        this.draw(pDDocument, pDPage, new Rectangle(point.getX(), point.getY(), this.getSize(pageContentInfo).getWidth(), this.getSize(pageContentInfo).getHeight()), pageContentInfo);
    }

    @Y
    private final void draw(PDDocument pDDocument, PDPage pDPage, Point point, PageInfo pageInfo) {
        PageSettings pageSettings = pageInfo.b();
        this.draw(pDDocument, pDPage, new Rectangle(point.getX(), point.getY(), (float)pageSettings.getPaperWidth(), (float)pageSettings.getPaperHeight()), pageInfo);
    }

    @Y
    public final void draw(PDDocument pDDocument, PDPage pDPage, Rectangle rectangle, IRange iRange) {
        this.draw(pDDocument, pDPage, rectangle, iRange, null);
    }

    @Y
    public final void draw(PDDocument pDDocument, PDPage pDPage, Rectangle rectangle, IRange iRange, PdfSaveOptions pdfSaveOptions) {
        PageSettings pageSettings = this.a(iRange.getWorksheet(), bF.a);
        o o2 = new o();
        dA dA2 = this.a(iRange.getWorksheet());
        boolean bl2 = pdfSaveOptions != null && pdfSaveOptions.getPrintTransparentCell();
        o2.a(dA2, iRange.getRow(), iRange.getColumn(), iRange.getRow() + iRange.getRows().getCount() - 1, iRange.getColumn() + iRange.getColumns().getCount() - 1, pageSettings, bl2);
        i.a(pDDocument, dA2.a().d());
        if (pdfSaveOptions != null) {
            if (pdfSaveOptions.getDocumentProperties() != null) {
                i.a(pDDocument, pdfSaveOptions.getDocumentProperties());
            }
            if (pdfSaveOptions.getSecurityOptions() != null) {
                i.a(pDDocument, pdfSaveOptions.getSecurityOptions());
            }
        }
        g g2 = null;
        PDPageContentStream pDPageContentStream = null;
        e e2 = new e();
        e2.a();
        try {
            pDPageContentStream = new PDPageContentStream(pDDocument, pDPage, PDPageContentStream.AppendMode.APPEND, true);
            g2 = new g(pDDocument, pDPage, pDPageContentStream, e2, pdfSaveOptions, null);
        }
        catch (IOException iOException) {
            this.a.debug((Object)iOException.getMessage());
        }
        R r2 = o2.E();
        if (r2 != null) {
            bN bN2 = this.a(iRange.getWorksheet()).c();
            double d2 = bN2.b().b(iRange.getRow(), iRange.getRow() + iRange.getRows().getCount() - 1) * dA2.a().c();
            double d3 = bN2.c().b(iRange.getColumn(), iRange.getColumn() + iRange.getColumns().getCount() - 1);
            double d4 = 1.0;
            if (d3 > rectangle.getWidth()) {
                d4 = rectangle.getWidth() / d3;
            }
            double d5 = 1.0;
            if (d2 > rectangle.getHeight()) {
                d5 = rectangle.getHeight() / d2;
            }
            double d6 = d4 < d5 ? d4 : d5;
            r2.d(d6, d6 * dA2.a().c());
            r2.c(rectangle.getX() + (rectangle.getWidth() - (d3 *= d6)) / 2.0, rectangle.getY() + (rectangle.getHeight() - (d2 *= d6)) / 2.0);
            r2.h();
            g2.a(r2);
            try {
                if (pDPageContentStream != null) {
                    pDPageContentStream.close();
                }
            }
            catch (IOException iOException) {
                this.a.debug((Object)iOException.getMessage());
            }
        }
        this.c.add(e2);
    }

    @Y
    public final void draw(PDDocument pDDocument, PDPage pDPage, Rectangle rectangle, PageContentInfo pageContentInfo) {
        this.draw(pDDocument, pDPage, rectangle, pageContentInfo, null);
    }

    @Y
    public final void draw(PDDocument pDDocument, PDPage pDPage, Rectangle rectangle, PageContentInfo pageContentInfo, PdfSaveOptions pdfSaveOptions) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageContent(pageContentInfo);
        pageInfo.setPageSettings(this.a(pageContentInfo.getRange().getWorksheet()).a(bF.a));
        Size size = this.getSize(pageContentInfo);
        pageInfo.getPageSettings().setPaperWidth(size.getWidth());
        pageInfo.getPageSettings().setPaperHeight(size.getHeight());
        pageInfo.getPageSettings().setTopMargin(0.0);
        pageInfo.getPageSettings().setBottomMargin(0.0);
        pageInfo.getPageSettings().setLeftMargin(0.0);
        pageInfo.getPageSettings().setRightMargin(0.0);
        this.draw(pDDocument, pDPage, rectangle, pageInfo, pdfSaveOptions);
    }

    @Y
    public final void draw(PDDocument pDDocument, PDPage pDPage, Rectangle rectangle, PageInfo pageInfo) {
        this.draw(pDDocument, pDPage, rectangle, pageInfo, null);
    }

    @Y
    public final void draw(PDDocument pDDocument, PDPage pDPage, Rectangle rectangle, PageInfo pageInfo, PdfSaveOptions pdfSaveOptions) {
        PDPageContentStream pDPageContentStream = null;
        try {
            pDPageContentStream = new PDPageContentStream(pDDocument, pDPage, PDPageContentStream.AppendMode.APPEND, true);
        }
        catch (IOException iOException) {
            this.a.debug((Object)iOException.getMessage());
        }
        am<e> am2 = new am<e>();
        i.a(this.a(pageInfo.getPageContent().getRange().getWorksheet()), pDDocument, pDPage, pDPageContentStream, rectangle, pageInfo, pdfSaveOptions, am2);
        this.c.add((e)am2.a);
        if (pDPageContentStream != null) {
            try {
                pDPageContentStream.close();
            }
            catch (IOException iOException) {
                this.a.debug((Object)iOException.getMessage());
            }
        }
    }

    private final cr a(IRange iRange, double d2, int n2, int n3, int n4, int n5, boolean bl2, int n6, double d3, boolean bl3) {
        return this.a(iRange, d2, n2, n3, n4, n5, bl2, n6, d3, bl3, false);
    }

    private final cr a(IRange iRange, double d2, int n2, int n3, int n4, int n5, boolean bl2, int n6, double d3, boolean bl3, boolean bl4) {
        boolean bl5;
        boolean bl6 = n2 >= 0 && n3 >= n2;
        boolean bl7 = bl5 = n4 >= 0 && n5 >= n4;
        if (bl4 && bl6 && n6 < n3) {
            n6 = Math.min(n6, n2);
            n2 = -1;
            n3 = -1;
            bl6 = false;
        }
        cr cr2 = new cr();
        cr2.a = this.a(iRange.getWorksheet());
        cr2.b = iRange.getWorksheet();
        cr2.a(d2);
        cr2.c = n2;
        cr2.d = n3;
        cr2.i = bl2;
        d3 /= this.a(iRange.getWorksheet()).a().c();
        if (d2 > 0.0 && d2 != 1.0) {
            d3 /= d2;
        }
        bN bN2 = this.a(iRange.getWorksheet()).c();
        bL bL2 = bN2.b();
        if (bl2) {
            d3 -= bN2.j();
        }
        if (bl6) {
            d3 -= bL2.b(n2, n3);
        }
        if (bl5) {
            d3 -= bL2.b(n4, n5);
        }
        if (d3 <= 0.0) {
            return null;
        }
        aF<Integer, Integer> aF2 = bL2.b(n6, d3);
        if ((Integer)aF2.a < 0 || (Integer)aF2.b < 0 || (Integer)aF2.a > iRange.getLastRow()) {
            return null;
        }
        cr2.g = (Integer)aF2.a;
        cr2.h = (Integer)aF2.b;
        if (bl4 && bl5 && cr2.h >= n4) {
            aF2 = bL2.b(n6, d3 += bL2.b(n4, n5));
            cr2.g = (Integer)aF2.a;
            cr2.h = (Integer)aF2.b;
            cr2.e = -1;
            cr2.f = -1;
        } else {
            cr2.e = n4;
            cr2.f = n5;
        }
        cr2.j = -1;
        cr2.k = 0;
        if (!bl3) {
            List<O> list = this.a(iRange.getWorksheet()).h();
            if (list == null || list.size() == 0) {
                return cr2;
            }
            for (O o2 : list) {
                if (o2.a > cr2.h) break;
                if (o2.a <= cr2.g || o2.b > iRange.getColumn() + iRange.getColumns().getCount() - 1 || o2.c <= iRange.getColumn()) continue;
                cr2.h = o2.a - 1;
            }
        }
        if (bl5 && cr2.h < n4) {
            cr2.e = n4;
            cr2.f = n5;
        }
        return cr2;
    }

    private final L a(IRange iRange, double d2, int n2, int n3, int n4, int n5, boolean bl2, double d3, int n6, double d4, boolean bl3) {
        return this.a(iRange, d2, n2, n3, n4, n5, bl2, d3, n6, d4, bl3, false);
    }

    private final L a(IRange iRange, double d2, int n2, int n3, int n4, int n5, boolean bl2, double d3, int n6, double d4, boolean bl3, boolean bl4) {
        boolean bl5;
        boolean bl6 = n2 >= 0 && n3 >= n2;
        boolean bl7 = bl5 = n4 >= 0 && n5 >= n4;
        if (bl4 && bl6 && n6 < n3) {
            n6 = Math.min(n6, n2);
            n2 = -1;
            n3 = -1;
            bl6 = false;
        }
        L l2 = new L();
        l2.a = this.a(iRange.getWorksheet());
        l2.b = iRange.getWorksheet();
        l2.a(d2);
        l2.c = n2;
        l2.d = n3;
        l2.j = bl2;
        l2.i = d3;
        l2.b = iRange.getWorksheet();
        if (d2 > 0.0 && d2 != 1.0) {
            d4 /= d2;
        }
        bN bN2 = this.a(iRange.getWorksheet()).c();
        bL bL2 = bN2.c();
        if (bl2) {
            d4 -= d3;
        }
        if (bl6) {
            d4 -= bL2.b(n2, n3);
        }
        if (bl5) {
            d4 -= bL2.b(n4, n5);
        }
        if (d4 <= 0.0) {
            return null;
        }
        aF<Integer, Integer> aF2 = bL2.b(n6, d4);
        if ((Integer)aF2.a < 0 || (Integer)aF2.b < 0 || (Integer)aF2.a > iRange.getLastColumn()) {
            return null;
        }
        l2.g = (Integer)aF2.a;
        l2.h = (Integer)aF2.b;
        if (bl5 && l2.h >= n4) {
            aF2 = bL2.b(n6, d4 += bL2.b(n4, n5));
            l2.g = (Integer)aF2.a;
            l2.h = (Integer)aF2.b;
            l2.e = -1;
            l2.f = -1;
        } else {
            l2.e = n4;
            l2.f = n5;
        }
        l2.l = 0;
        l2.k = -1;
        if (!bl3) {
            List<O> list = this.a(iRange.getWorksheet()).i();
            if (list == null || list.size() == 0) {
                return l2;
            }
            for (O o2 : list) {
                if (o2.a > l2.h) break;
                if (o2.a <= l2.g || o2.b > iRange.getRow() + iRange.getRows().getCount() - 1 || o2.c <= iRange.getRow()) continue;
                l2.h = o2.a - 1;
            }
        }
        if (bl5 && l2.h < n4) {
            l2.e = n4;
            l2.f = n5;
        }
        return l2;
    }

    public final PageContentInfo a(IRange iRange, Size size, int n2, int n3, boolean bl2, boolean bl3, double d2, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, double d3, boolean bl4) {
        return this.a(iRange, size, n2, n3, bl2, bl3, d2, n4, n5, n6, n7, n8, n9, n10, n11, d3, bl4, false);
    }

    private final PageContentInfo a(IRange iRange, Size size, int n2, int n3, boolean bl2, boolean bl3, double d2, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, double d3) {
        return this.a(iRange, size, n2, n3, bl2, bl3, d2, n4, n5, n6, n7, n8, n9, n10, n11, d3, false, false);
    }

    private final PageContentInfo a(IRange iRange, Size size, int n2, int n3, boolean bl2, boolean bl3, double d2, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, double d3, boolean bl4, boolean bl5) {
        PageContentInfo pageContentInfo = new PageContentInfo();
        pageContentInfo.setZoomFactor(d3);
        pageContentInfo.setTitleRowStart(n4);
        pageContentInfo.setTitleRowEnd(n5);
        pageContentInfo.setTailRowStart(n6);
        pageContentInfo.setTailRowEnd(n7);
        pageContentInfo.setColumnHeaderVisible(bl3);
        pageContentInfo.setTitleColumnStart(n8);
        pageContentInfo.setTitleColumnEnd(n9);
        pageContentInfo.setTailColumnStart(n10);
        pageContentInfo.setTailColumnEnd(n11);
        pageContentInfo.setRowHeaderVisible(bl2);
        pageContentInfo.a(d2);
        pageContentInfo.b(0);
        pageContentInfo.a(-1);
        pageContentInfo.d(0);
        pageContentInfo.c(-1);
        pageContentInfo.a(this.a(iRange.getWorksheet()), iRange, n2, n3, size, bl4, bl5, false);
        return pageContentInfo;
    }

    @Y
    public final List<IRange> getPrintAreas(IWorksheet iWorksheet) {
        return this.a(iWorksheet).d();
    }

    public final PageSettings a(IWorksheet iWorksheet, bF bF2) {
        return this.a(iWorksheet).a(bF2);
    }

    @Y
    public List<Integer> GetPaginationInfo(IWorksheet iWorksheet, PaginationOrientation paginationOrientation) {
        if (paginationOrientation == PaginationOrientation.Horizontal) {
            return i.b(this.a(iWorksheet));
        }
        return i.c(this.a(iWorksheet));
    }

    @Y
    public List<Integer> GetPaginationInfo(IWorksheet iWorksheet, PaginationOrientation paginationOrientation, List<IRange> list, List<RepeatSetting> list2) {
        List<IRange> list3 = this.a(iWorksheet).d();
        if (list3.size() <= 0) {
            return null;
        }
        boolean bl2 = true;
        boolean bl3 = true;
        if (iWorksheet.getPageSetup().getIsPercentScale() || iWorksheet.getPageSetup().getFitToPagesTall() <= 0) {
            bl2 = false;
        }
        if (iWorksheet.getPageSetup().getIsPercentScale() || iWorksheet.getPageSetup().getFitToPagesWide() <= 0) {
            bl3 = false;
        }
        double d2 = this.a(iWorksheet, list, list2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (IRange iRange : list3) {
            ArrayList<Object> arrayList2;
            PageSettings pageSettings = this.a(iWorksheet, bF.a);
            double d3 = pageSettings.getPaperWidth() - pageSettings.getLeftMargin() - pageSettings.getRightMargin();
            double d4 = pageSettings.getPaperHeight() - pageSettings.getTopMargin() - pageSettings.getBottomMargin();
            if (paginationOrientation == PaginationOrientation.Horizontal) {
                arrayList2 = this.b(iRange, d3, list, list2, d2, bl3);
                for (Object object : arrayList2) {
                    arrayList.add(((L)object).h);
                }
                continue;
            }
            arrayList2 = this.a(iRange, d4, list, list2, d2, bl2);
            for (Object object : arrayList2) {
                arrayList.add(((cr)object).h);
            }
        }
        return arrayList;
    }

    private double a(IWorksheet iWorksheet, List<IRange> list, List<RepeatSetting> list2) {
        List<IRange> list3 = this.a(iWorksheet).d();
        if (list3.size() <= 0) {
            return 1.0;
        }
        if (iWorksheet.getPageSetup().getIsPercentScale()) {
            return (double)iWorksheet.getPageSetup().getZoom() / 100.0;
        }
        double d2 = 1.0;
        for (IRange iRange : list3) {
            PageSettings pageSettings = this.a(iWorksheet, bF.a);
            double d3 = pageSettings.getPaperWidth() - pageSettings.getLeftMargin() - pageSettings.getRightMargin();
            double d4 = pageSettings.getPaperHeight() - pageSettings.getTopMargin() - pageSettings.getBottomMargin();
            Size size = new Size(d3, d4);
            d2 = this.a(this.a(iRange.getWorksheet()), iRange, size, d2, list, list2);
        }
        d2 = (double)((int)(d2 * 100.0)) / 100.0;
        return d2;
    }

    private double a(dA dA2, IRange iRange, Size size, double d2, List<IRange> list, List<RepeatSetting> list2) {
        if (dA2.b().getPageSetup().getFitToPagesTall() > 0) {
            d2 = this.a(dA2, iRange, size.getHeight(), dA2.b().getPageSetup().getFitToPagesTall(), d2, list, list2);
        }
        if (dA2.b().getPageSetup().getFitToPagesWide() > 0) {
            d2 = this.b(dA2, iRange, size.getWidth(), dA2.b().getPageSetup().getFitToPagesWide(), d2, list, list2);
        }
        return d2;
    }

    private double a(dA dA2, IRange iRange, double d2, int n2, double d3, List<IRange> list, List<RepeatSetting> list2) {
        ArrayList<cr> arrayList = this.a(iRange, d2, list, list2, d3, true);
        if (arrayList.size() <= n2) {
            return d3;
        }
        double d4 = d3;
        double d5 = 0.0;
        double d6 = (double)n2 * d3 / (double)arrayList.size();
        int n3 = 0;
        while (n3++ < 20) {
            arrayList = this.a(iRange, d2, list, list2, d6, true);
            if (arrayList.size() > n2) {
                d4 = d6;
            } else {
                d5 = d6;
            }
            if (Math.abs(d4 - d5) < 0.01) break;
            d6 = (d4 + d5) / 2.0;
        }
        if (arrayList.size() > n2) {
            d6 = d5;
        }
        return d6;
    }

    private double b(dA dA2, IRange iRange, double d2, int n2, double d3, List<IRange> list, List<RepeatSetting> list2) {
        ArrayList<L> arrayList = this.b(iRange, d2, list, list2, d3, true);
        if (arrayList.size() <= n2) {
            return d3;
        }
        double d4 = d3;
        double d5 = 0.0;
        double d6 = (double)n2 * d3 / (double)arrayList.size();
        int n3 = 0;
        while (n3++ < 20) {
            arrayList = this.b(iRange, d2, list, list2, d6, true);
            if (arrayList.size() > n2) {
                d4 = d6;
            } else {
                d5 = d6;
            }
            if (Math.abs(d4 - d5) < 0.01) break;
            d6 = (d4 + d5) / 2.0;
        }
        if (arrayList.size() > n2) {
            d6 = d5;
        }
        return d6;
    }
}

