/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.predicates.IntObjectPredicate;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.PathBidirRef;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class AlternativeRoute
implements RoutingAlgorithm {
    private static final Comparator<AlternativeInfo> ALT_COMPARATOR = new Comparator<AlternativeInfo>(){

        @Override
        public int compare(AlternativeInfo o1, AlternativeInfo o2) {
            return Double.compare(o1.sortBy, o2.sortBy);
        }
    };
    private final Graph graph;
    private final Weighting weighting;
    private final TraversalMode traversalMode;
    private int visitedNodes;
    private int maxVisitedNodes = Integer.MAX_VALUE;
    private double maxWeightFactor = 1.4;
    private double maxExplorationFactor = 0.8;
    private double maxShareFactor = 0.6;
    private double minPlateauFactor = 0.2;
    private int maxPaths = 2;
    private WeightApproximator weightApproximator;

    public AlternativeRoute(Graph graph, Weighting weighting, TraversalMode traversalMode) {
        this.graph = graph;
        this.weighting = weighting;
        this.traversalMode = traversalMode;
    }

    public void setApproximation(WeightApproximator weightApproximator) {
        this.weightApproximator = weightApproximator;
    }

    static List<String> getAltNames(Graph graph, SPTEntry ee) {
        if (ee == null || !EdgeIterator.Edge.isValid(ee.edge)) {
            return Collections.emptyList();
        }
        EdgeIteratorState iter = graph.getEdgeIteratorState(ee.edge, Integer.MIN_VALUE);
        if (iter == null) {
            return Collections.emptyList();
        }
        String str = iter.getName();
        if (str.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(str);
    }

    static double calcSortBy(double weightInfluence, double weight, double shareInfluence, double shareWeight, double plateauInfluence, double plateauWeight) {
        return weightInfluence * weight + shareInfluence * shareWeight + plateauInfluence * plateauWeight;
    }

    @Override
    public void setMaxVisitedNodes(int numberOfNodes) {
        this.maxVisitedNodes = numberOfNodes;
    }

    public void setMaxWeightFactor(double maxWeightFactor) {
        this.maxWeightFactor = maxWeightFactor;
    }

    public void setMaxShareFactor(double maxShareFactor) {
        this.maxShareFactor = maxShareFactor;
    }

    public void setMinPlateauFactor(double minPlateauFactor) {
        this.minPlateauFactor = minPlateauFactor;
    }

    public void setMaxExplorationFactor(double explorationFactor) {
        this.maxExplorationFactor = explorationFactor;
    }

    public void setMaxPaths(int maxPaths) {
        this.maxPaths = maxPaths;
        if (this.maxPaths < 2) {
            throw new IllegalStateException("Use normal algorithm with less overhead instead if no alternatives are required");
        }
    }

    public List<AlternativeInfo> calcAlternatives(int from, int to) {
        AlternativeBidirSearch altBidirDijktra = new AlternativeBidirSearch(this.graph, this.weighting, this.traversalMode, this.maxExplorationFactor * 2.0);
        altBidirDijktra.setMaxVisitedNodes(this.maxVisitedNodes);
        if (this.weightApproximator != null) {
            altBidirDijktra.setApproximation(this.weightApproximator);
        }
        altBidirDijktra.searchBest(from, to);
        this.visitedNodes = altBidirDijktra.getVisitedNodes();
        List<AlternativeInfo> alternatives = altBidirDijktra.calcAlternatives(this.maxPaths, this.maxWeightFactor, 7.0, this.maxShareFactor, 0.8, this.minPlateauFactor, -0.2);
        return alternatives;
    }

    @Override
    public Path calcPath(int from, int to) {
        return this.calcPaths(from, to).get(0);
    }

    @Override
    public List<Path> calcPaths(int from, int to) {
        List<AlternativeInfo> alts = this.calcAlternatives(from, to);
        ArrayList<Path> paths = new ArrayList<Path>(alts.size());
        for (AlternativeInfo a : alts) {
            paths.add(a.getPath());
        }
        return paths;
    }

    @Override
    public String getName() {
        return "alternative_route";
    }

    @Override
    public int getVisitedNodes() {
        return this.visitedNodes;
    }

    public static class PlateauInfo {
        String name;
        List<Integer> edges;

        public PlateauInfo(String name, List<Integer> edges) {
            this.name = name;
            this.edges = edges;
        }

        public String toString() {
            return this.name;
        }

        public List<Integer> getEdges() {
            return this.edges;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class AlternativeBidirSearch
    extends AStarBidirection {
        private final double explorationFactor;

        public AlternativeBidirSearch(Graph graph, Weighting weighting, TraversalMode tMode, double explorationFactor) {
            super(graph, weighting, tMode);
            this.explorationFactor = explorationFactor;
        }

        @Override
        public boolean finished() {
            if (this.finishedFrom && this.finishedTo) {
                return true;
            }
            if (this.isMaxVisitedNodesExceeded()) {
                return true;
            }
            if (!this.bestPath.isFound() && (this.finishedFrom || this.finishedTo)) {
                return true;
            }
            return this.currFrom.weight + this.currTo.weight > this.explorationFactor * this.bestPath.getWeight();
        }

        public Path searchBest(int from, int to) {
            this.createAndInitPath();
            this.init(from, 0.0, to, 0.0);
            this.runAlgo();
            return this.extractPath();
        }

        public List<AlternativeInfo> calcAlternatives(final int maxPaths, double maxWeightFactor, final double weightInfluence, final double maxShareFactor, final double shareInfluence, final double minPlateauFactor, final double plateauInfluence) {
            final double maxWeight = maxWeightFactor * this.bestPath.getWeight();
            final GHIntObjectHashMap<IntSet> traversalIdMap = new GHIntObjectHashMap<IntSet>();
            final AtomicInteger startTID = this.addToMap(traversalIdMap, this.bestPath);
            final ArrayList<AlternativeInfo> alternatives = new ArrayList<AlternativeInfo>(maxPaths);
            double bestPlateau = this.bestPath.getWeight();
            double bestShare = 0.0;
            double sortBy = AlternativeRoute.calcSortBy(weightInfluence, this.bestPath.getWeight(), shareInfluence, bestShare, plateauInfluence, bestPlateau);
            final AlternativeInfo bestAlt = new AlternativeInfo(sortBy, this.bestPath, this.bestPath.sptEntry, this.bestPath.edgeTo, bestShare, AlternativeRoute.getAltNames(this.graph, this.bestPath.sptEntry));
            alternatives.add(bestAlt);
            final ArrayList bestPathEntries = new ArrayList(2);
            this.bestWeightMapFrom.forEach((IntObjectPredicate)new IntObjectPredicate<SPTEntry>(){

                public boolean apply(int traversalId, SPTEntry fromSPTEntry) {
                    boolean smallShare;
                    int nextFromTraversalId;
                    SPTEntry nextFromSPTEntry;
                    SPTEntry tmpFromEntry;
                    double weight;
                    SPTEntry toSPTEntry = (SPTEntry)AlternativeBidirSearch.this.bestWeightMapTo.get(traversalId);
                    if (toSPTEntry == null) {
                        return true;
                    }
                    if (AlternativeBidirSearch.this.traversalMode.isEdgeBased()) {
                        if (toSPTEntry.parent != null) {
                            toSPTEntry = toSPTEntry.parent;
                        }
                    } else if (fromSPTEntry.edge == toSPTEntry.edge) {
                        return true;
                    }
                    if ((weight = fromSPTEntry.getWeightOfVisitedPath() + toSPTEntry.getWeightOfVisitedPath()) > maxWeight) {
                        return true;
                    }
                    if (this.isBestPath(fromSPTEntry, AlternativeBidirSearch.this.bestPath)) {
                        return true;
                    }
                    SPTEntry sPTEntry = tmpFromEntry = AlternativeBidirSearch.this.traversalMode.isEdgeBased() ? fromSPTEntry.parent : fromSPTEntry;
                    if (tmpFromEntry == null || tmpFromEntry.parent == null) {
                        assert (AlternativeBidirSearch.this.traversalMode.isEdgeBased());
                    } else {
                        int nextToTraversalId = AlternativeBidirSearch.this.traversalMode.createTraversalId(tmpFromEntry.adjNode, tmpFromEntry.parent.adjNode, tmpFromEntry.edge, true);
                        SPTEntry tmpNextToSPTEntry = (SPTEntry)AlternativeBidirSearch.this.bestWeightMapTo.get(nextToTraversalId);
                        if (tmpNextToSPTEntry == null) {
                            return true;
                        }
                        if (AlternativeBidirSearch.this.traversalMode.isEdgeBased()) {
                            tmpNextToSPTEntry = tmpNextToSPTEntry.parent;
                        }
                        if (fromSPTEntry.edge == tmpNextToSPTEntry.edge) {
                            return true;
                        }
                    }
                    double plateauWeight = 0.0;
                    SPTEntry prevToSPTEntry = toSPTEntry;
                    while (prevToSPTEntry.parent != null && (nextFromSPTEntry = (SPTEntry)AlternativeBidirSearch.this.bestWeightMapFrom.get(nextFromTraversalId = AlternativeBidirSearch.this.traversalMode.createTraversalId(prevToSPTEntry.adjNode, prevToSPTEntry.parent.adjNode, prevToSPTEntry.edge, false))) != null && prevToSPTEntry.edge == nextFromSPTEntry.edge) {
                        plateauWeight += prevToSPTEntry.getWeightOfVisitedPath() - prevToSPTEntry.parent.getWeightOfVisitedPath();
                        prevToSPTEntry = prevToSPTEntry.parent;
                    }
                    if (plateauWeight <= 0.0 || plateauWeight / weight < minPlateauFactor) {
                        return true;
                    }
                    if (fromSPTEntry.parent == null) {
                        throw new IllegalStateException("not implemented yet. in case of an edge based traversal the parent of fromSPTEntry could be null");
                    }
                    SPTEntry fromEE = this.getFirstShareEE(fromSPTEntry.parent, true);
                    SPTEntry toEE = this.getFirstShareEE(toSPTEntry.parent, false);
                    double shareWeight = fromEE.getWeightOfVisitedPath() + toEE.getWeightOfVisitedPath();
                    boolean bl = smallShare = shareWeight / AlternativeBidirSearch.this.bestPath.getWeight() < maxShareFactor;
                    if (smallShare) {
                        double worstSortBy;
                        List<String> altNames = AlternativeRoute.getAltNames(AlternativeBidirSearch.this.graph, fromSPTEntry);
                        double sortBy = AlternativeRoute.calcSortBy(weightInfluence, weight, shareInfluence, shareWeight, plateauInfluence, plateauWeight);
                        if (sortBy < (worstSortBy = this.getWorstSortBy()) || alternatives.size() < maxPaths) {
                            Path path = new PathBidirRef(AlternativeBidirSearch.this.graph, AlternativeBidirSearch.this.weighting).setSPTEntryTo(toSPTEntry).setSPTEntry(fromSPTEntry).setWeight(weight);
                            path.extract();
                            alternatives.add(new AlternativeInfo(sortBy, path, fromEE, toEE, shareWeight, altNames));
                            Collections.sort(alternatives, ALT_COMPARATOR);
                            if (alternatives.get(0) != bestAlt) {
                                throw new IllegalStateException("best path should be always first entry");
                            }
                            if (alternatives.size() > maxPaths) {
                                alternatives.subList(maxPaths, alternatives.size()).clear();
                            }
                        }
                    }
                    return true;
                }

                SPTEntry getFirstShareEE(SPTEntry startEE, boolean reverse) {
                    while (startEE.parent != null) {
                        int tid = AlternativeBidirSearch.this.traversalMode.createTraversalId(startEE.adjNode, startEE.parent.adjNode, startEE.edge, reverse);
                        if (this.isAlreadyExisting(tid)) {
                            return startEE;
                        }
                        startEE = startEE.parent;
                    }
                    return startEE;
                }

                boolean isAlreadyExisting(final int tid) {
                    final AtomicBoolean exists = new AtomicBoolean(false);
                    traversalIdMap.forEach((IntObjectPredicate)new IntObjectPredicate<IntSet>(){

                        public boolean apply(int key, IntSet set) {
                            if (set.contains(tid)) {
                                exists.set(true);
                                return false;
                            }
                            return true;
                        }
                    });
                    return exists.get();
                }

                double getWorstSortBy() {
                    if (alternatives.isEmpty()) {
                        throw new IllegalStateException("Empty alternative list cannot happen");
                    }
                    return ((AlternativeInfo)alternatives.get(alternatives.size() - 1)).sortBy;
                }

                boolean isBestPath(SPTEntry fromSPTEntry, Path bestPath) {
                    if (AlternativeBidirSearch.this.traversalMode.isEdgeBased()) {
                        if (GHUtility.getEdgeFromEdgeKey(startTID.get()) == fromSPTEntry.edge) {
                            if (fromSPTEntry.parent == null) {
                                throw new IllegalStateException("best path must have no parent but was non-null: " + fromSPTEntry);
                            }
                            return true;
                        }
                    } else if (fromSPTEntry.parent == null) {
                        bestPathEntries.add(fromSPTEntry);
                        if (bestPathEntries.size() > 1) {
                            throw new IllegalStateException("There is only one best path but was: " + bestPathEntries);
                        }
                        if (startTID.get() != fromSPTEntry.adjNode) {
                            throw new IllegalStateException("Start traversal ID has to be identical to root edge entry which is the plateau start of the best path but was: " + startTID + " vs. adjNode: " + fromSPTEntry.adjNode);
                        }
                        return true;
                    }
                    return false;
                }
            });
            return alternatives;
        }

        AtomicInteger addToMap(GHIntObjectHashMap<IntSet> map, Path path) {
            GHIntHashSet set = new GHIntHashSet();
            AtomicInteger startTID = new AtomicInteger(-1);
            for (EdgeIteratorState iterState : path.calcEdges()) {
                int tid = this.traversalMode.createTraversalId(iterState, false);
                set.add(tid);
                if (startTID.get() >= 0) continue;
                if (!this.traversalMode.isEdgeBased()) {
                    tid = iterState.getBaseNode();
                    set.add(tid);
                }
                startTID.set(tid);
            }
            map.put(startTID.get(), (Object)set);
            return startTID;
        }
    }

    public static class AlternativeInfo {
        private final double sortBy;
        private final Path path;
        private final SPTEntry shareStart;
        private final SPTEntry shareEnd;
        private final double shareWeight;
        private final List<String> names;

        public AlternativeInfo(double sortBy, Path path, SPTEntry shareStart, SPTEntry shareEnd, double shareWeight, List<String> altNames) {
            this.names = altNames;
            this.sortBy = sortBy;
            this.path = path;
            this.path.setDescription(this.names);
            this.shareStart = shareStart;
            this.shareEnd = shareEnd;
            this.shareWeight = shareWeight;
        }

        public Path getPath() {
            return this.path;
        }

        public SPTEntry getShareStart() {
            return this.shareStart;
        }

        public SPTEntry getShareEnd() {
            return this.shareEnd;
        }

        public double getShareWeight() {
            return this.shareWeight;
        }

        public double getSortBy() {
            return this.sortBy;
        }

        public String toString() {
            return this.names + ", sortBy:" + this.sortBy + ", shareWeight:" + this.shareWeight + ", " + this.path;
        }
    }
}

