/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.Path;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeIterator;

public class PathBidirRef
extends Path {
    protected SPTEntry edgeTo;
    private boolean switchFromAndToSPTEntry = false;

    public PathBidirRef(Graph g, Weighting weighting) {
        super(g, weighting);
    }

    PathBidirRef(PathBidirRef p) {
        super(p);
        this.edgeTo = p.edgeTo;
        this.switchFromAndToSPTEntry = p.switchFromAndToSPTEntry;
    }

    public PathBidirRef setSwitchToFrom(boolean b) {
        this.switchFromAndToSPTEntry = b;
        return this;
    }

    public PathBidirRef setSPTEntryTo(SPTEntry edgeTo) {
        this.edgeTo = edgeTo;
        return this;
    }

    @Override
    public Path extract() {
        if (this.sptEntry == null || this.edgeTo == null) {
            return this;
        }
        if (this.sptEntry.adjNode != this.edgeTo.adjNode) {
            throw new IllegalStateException("Locations of the 'to'- and 'from'-Edge have to be the same. " + this.toString() + ", fromEntry:" + this.sptEntry + ", toEntry:" + this.edgeTo);
        }
        this.extractSW.start();
        if (this.switchFromAndToSPTEntry) {
            SPTEntry ee = this.sptEntry;
            this.sptEntry = this.edgeTo;
            this.edgeTo = ee;
        }
        SPTEntry currEdge = this.sptEntry;
        boolean nextEdgeValid = EdgeIterator.Edge.isValid(currEdge.edge);
        while (nextEdgeValid) {
            nextEdgeValid = EdgeIterator.Edge.isValid(currEdge.parent.edge);
            int nextEdge = nextEdgeValid ? currEdge.parent.edge : -1;
            this.processEdge(currEdge.edge, currEdge.adjNode, nextEdge);
            currEdge = currEdge.parent;
        }
        this.setFromNode(currEdge.adjNode);
        this.reverseOrder();
        currEdge = this.edgeTo;
        int prevEdge = nextEdgeValid ? this.sptEntry.edge : -1;
        int tmpEdge = currEdge.edge;
        while (EdgeIterator.Edge.isValid(tmpEdge)) {
            currEdge = currEdge.parent;
            this.processEdge(tmpEdge, currEdge.adjNode, prevEdge);
            prevEdge = tmpEdge;
            tmpEdge = currEdge.edge;
        }
        this.setEndNode(currEdge.adjNode);
        this.extractSW.stop();
        return this.setFound(true);
    }
}

