/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.RoutingAlgorithmFactoryDecorator;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.util.CmdArgs;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHAlgoFactoryDecorator
implements RoutingAlgorithmFactoryDecorator {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final List<PrepareContractionHierarchies> preparations = new ArrayList<PrepareContractionHierarchies>();
    private final List<Weighting> nodeBasedWeightings = new ArrayList<Weighting>();
    private final List<Weighting> edgeBasedWeightings = new ArrayList<Weighting>();
    private final Set<String> weightingsAsStrings = new LinkedHashSet<String>();
    private boolean disablingAllowed = false;
    private boolean enabled = true;
    private EdgeBasedCHMode edgeBasedCHMode = EdgeBasedCHMode.OFF;
    private int preparationThreads;
    private ExecutorService threadPool;
    private PMap pMap = new PMap();

    public CHAlgoFactoryDecorator() {
        this.setPreparationThreads(1);
        this.setWeightingsAsStrings(Arrays.asList(this.getDefaultWeighting()));
    }

    @Override
    public void init(CmdArgs args) {
        String edgeBasedCHStr;
        if (!args.get("prepare.threads", "").isEmpty()) {
            throw new IllegalStateException("Use prepare.ch.threads instead of prepare.threads");
        }
        if (!args.get("prepare.chWeighting", "").isEmpty() || !args.get("prepare.chWeightings", "").isEmpty()) {
            throw new IllegalStateException("Use prepare.ch.weightings and a comma separated list instead of prepare.chWeighting or prepare.chWeightings");
        }
        this.setPreparationThreads(args.getInt("prepare.ch.threads", this.getPreparationThreads()));
        String chWeightingsStr = args.get("prepare.ch.weightings", "");
        if ("no".equals(chWeightingsStr) || "false".equals(chWeightingsStr)) {
            this.weightingsAsStrings.clear();
        } else if (!chWeightingsStr.isEmpty()) {
            List<String> tmpCHWeightingList = Arrays.asList(chWeightingsStr.split(","));
            this.setWeightingsAsStrings(tmpCHWeightingList);
        }
        boolean enableThis = !this.weightingsAsStrings.isEmpty();
        this.setEnabled(enableThis);
        if (enableThis) {
            this.setDisablingAllowed(args.getBool("routing.ch.disabling_allowed", this.isDisablingAllowed()));
        }
        edgeBasedCHStr = (edgeBasedCHStr = args.get("prepare.ch.edge_based", "off").trim()).equals("false") ? "off" : edgeBasedCHStr;
        this.edgeBasedCHMode = EdgeBasedCHMode.valueOf(edgeBasedCHStr.toUpperCase(Locale.ROOT));
        this.pMap = args;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    public final CHAlgoFactoryDecorator setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public final boolean isDisablingAllowed() {
        return this.disablingAllowed || !this.isEnabled();
    }

    public final CHAlgoFactoryDecorator setDisablingAllowed(boolean disablingAllowed) {
        this.disablingAllowed = disablingAllowed;
        return this;
    }

    public final CHAlgoFactoryDecorator setEdgeBasedCHMode(EdgeBasedCHMode edgeBasedCHMode) {
        this.edgeBasedCHMode = edgeBasedCHMode;
        return this;
    }

    public CHAlgoFactoryDecorator addNodeBasedWeighting(Weighting weighting) {
        this.nodeBasedWeightings.add(weighting);
        return this;
    }

    public CHAlgoFactoryDecorator addEdgeBasedWeighting(Weighting weighting) {
        this.edgeBasedWeightings.add(weighting);
        return this;
    }

    public CHAlgoFactoryDecorator addWeighting(String weighting) {
        this.weightingsAsStrings.add(weighting);
        return this;
    }

    public CHAlgoFactoryDecorator addPreparation(PrepareContractionHierarchies pch) {
        List<Weighting> weightings;
        int index = 0;
        for (PrepareContractionHierarchies p : this.preparations) {
            if (p.isEdgeBased() != pch.isEdgeBased()) continue;
            ++index;
        }
        List<Weighting> list = weightings = pch.isEdgeBased() ? this.edgeBasedWeightings : this.nodeBasedWeightings;
        if (index >= weightings.size()) {
            throw new IllegalStateException("Cannot access weighting for PrepareContractionHierarchies with " + pch.getWeighting() + ". Call add(Weighting) before");
        }
        Weighting expectedWeighting = weightings.get(index);
        if (pch.getWeighting() != expectedWeighting) {
            throw new IllegalArgumentException("Weighting of PrepareContractionHierarchies " + pch + " needs to be identical to previously added " + expectedWeighting);
        }
        this.preparations.add(pch);
        return this;
    }

    public final boolean hasWeightings() {
        return !this.nodeBasedWeightings.isEmpty() || !this.edgeBasedWeightings.isEmpty();
    }

    public final List<Weighting> getNodeBasedWeightings() {
        return this.nodeBasedWeightings;
    }

    public final List<Weighting> getEdgeBasedWeightings() {
        return this.edgeBasedWeightings;
    }

    public EdgeBasedCHMode getEdgeBasedCHMode() {
        return this.edgeBasedCHMode;
    }

    public CHAlgoFactoryDecorator setWeightingsAsStrings(String ... weightingNames) {
        return this.setWeightingsAsStrings(Arrays.asList(weightingNames));
    }

    public List<String> getWeightingsAsStrings() {
        if (this.weightingsAsStrings.isEmpty()) {
            throw new IllegalStateException("Potential bug: weightingsAsStrings is empty");
        }
        return new ArrayList<String>(this.weightingsAsStrings);
    }

    public CHAlgoFactoryDecorator setWeightingsAsStrings(List<String> weightingList) {
        if (weightingList.isEmpty()) {
            throw new IllegalArgumentException("It is not allowed to pass an emtpy weightingList");
        }
        this.weightingsAsStrings.clear();
        for (String strWeighting : weightingList) {
            strWeighting = Helper.toLowerCase((String)strWeighting);
            strWeighting = strWeighting.trim();
            this.addWeighting(strWeighting);
        }
        return this;
    }

    private String getDefaultWeighting() {
        return this.weightingsAsStrings.isEmpty() ? "fastest" : this.weightingsAsStrings.iterator().next();
    }

    public List<PrepareContractionHierarchies> getPreparations() {
        return this.preparations;
    }

    @Override
    public RoutingAlgorithmFactory getDecoratedAlgorithmFactory(RoutingAlgorithmFactory defaultAlgoFactory, HintsMap map) {
        boolean disableCH = map.getBool("ch.disable", false);
        if (!this.isEnabled() || this.disablingAllowed && disableCH) {
            return defaultAlgoFactory;
        }
        List<PrepareContractionHierarchies> allPreparations = this.getPreparations();
        if (allPreparations.isEmpty()) {
            throw new IllegalStateException("No preparations added to this decorator");
        }
        if (map.getWeighting().isEmpty()) {
            map.setWeighting(this.getDefaultWeighting());
        }
        return this.getPreparation(map);
    }

    public PrepareContractionHierarchies getPreparation(HintsMap map) {
        boolean edgeBased = map.getBool("edge_based", false);
        ArrayList<String> entriesStrs = new ArrayList<String>();
        boolean weightingMatchesButNotEdgeBased = false;
        for (PrepareContractionHierarchies p : this.getPreparations()) {
            boolean weightingMatches = p.getWeighting().matches(map);
            if (p.isEdgeBased() == edgeBased && weightingMatches) {
                return p;
            }
            if (weightingMatches) {
                weightingMatchesButNotEdgeBased = true;
            }
            entriesStrs.add(p.getWeighting() + "|" + (p.isEdgeBased() ? "edge" : "node"));
        }
        String hint = weightingMatchesButNotEdgeBased ? " The 'edge_based' url parameter is missing or does not fit the weightings. Its value was: '" + edgeBased + "'" : "";
        throw new IllegalArgumentException("Cannot find CH RoutingAlgorithmFactory for weighting map " + map + " in entries: " + entriesStrs + "." + hint);
    }

    public int getPreparationThreads() {
        return this.preparationThreads;
    }

    public void setPreparationThreads(int preparationThreads) {
        this.preparationThreads = preparationThreads;
        this.threadPool = Executors.newFixedThreadPool(preparationThreads);
    }

    public void prepare(final StorableProperties properties) {
        ExecutorCompletionService<String> completionService = new ExecutorCompletionService<String>(this.threadPool);
        int counter = 0;
        for (final PrepareContractionHierarchies prepare : this.getPreparations()) {
            this.LOGGER.info(++counter + "/" + this.getPreparations().size() + " calling " + (prepare.isEdgeBased() ? "edge" : "node") + "-based CH prepare.doWork for " + prepare.getWeighting() + " ... (" + Helper.getMemInfo() + ")");
            final String name = AbstractWeighting.weightingToFileName(prepare.getWeighting(), prepare.isEdgeBased());
            completionService.submit(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setName(name);
                    prepare.doWork();
                    properties.put("prepare.ch.date." + name, Helper.createFormatter().format(new Date()));
                }
            }, name);
        }
        this.threadPool.shutdown();
        try {
            for (int i = 0; i < this.getPreparations().size(); ++i) {
                completionService.take().get();
            }
        }
        catch (Exception e) {
            this.threadPool.shutdownNow();
            throw new RuntimeException(e);
        }
    }

    public void createPreparations(GraphHopperStorage ghStorage) {
        if (!this.isEnabled() || !this.getPreparations().isEmpty()) {
            return;
        }
        if (!this.hasWeightings()) {
            throw new IllegalStateException("No CH weightings found");
        }
        for (Weighting weighting : this.nodeBasedWeightings) {
            this.addPreparation(this.createCHPreparation(ghStorage, weighting, TraversalMode.NODE_BASED));
        }
        for (Weighting weighting : this.edgeBasedWeightings) {
            this.addPreparation(this.createCHPreparation(ghStorage, weighting, TraversalMode.EDGE_BASED_2DIR));
        }
    }

    private PrepareContractionHierarchies createCHPreparation(GraphHopperStorage ghStorage, Weighting weighting, TraversalMode traversalMode) {
        PrepareContractionHierarchies tmpPrepareCH = PrepareContractionHierarchies.fromGraphHopperStorage(ghStorage, weighting, traversalMode);
        tmpPrepareCH.setParams(this.pMap);
        return tmpPrepareCH;
    }

    public static enum EdgeBasedCHMode {
        OFF,
        EDGE_OR_NODE,
        EDGE_AND_NODE;

    }
}

