/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.DijkstraOneToMany;
import com.graphhopper.routing.ch.AbstractNodeContractor;
import com.graphhopper.routing.ch.PreparationWeighting;
import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.IgnoreNodeFilter;
import com.graphhopper.routing.util.LevelEdgeFilter;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.CHEdgeExplorer;
import com.graphhopper.util.CHEdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class NodeBasedNodeContractor
extends AbstractNodeContractor {
    private final PreparationWeighting prepareWeighting;
    private final Map<Shortcut, Shortcut> shortcuts = new HashMap<Shortcut, Shortcut>();
    private final AddShortcutHandler addScHandler = new AddShortcutHandler();
    private final CalcShortcutHandler calcScHandler = new CalcShortcutHandler();
    private final Params params = new Params();
    private CHEdgeExplorer remainingEdgeExplorer;
    private IgnoreNodeFilter ignoreNodeFilter;
    private DijkstraOneToMany prepareAlgo;
    private int addedShortcutsCount;
    private long dijkstraCount;
    private StopWatch dijkstraSW = new StopWatch();
    private double meanDegree;

    NodeBasedNodeContractor(CHGraph prepareGraph, Weighting weighting, PMap pMap) {
        super(prepareGraph, weighting);
        this.prepareWeighting = new PreparationWeighting(weighting);
        this.extractParams(pMap);
    }

    private void extractParams(PMap pMap) {
        this.params.edgeDifferenceWeight = pMap.getFloat("prepare.ch.node.edge_difference_weight", this.params.edgeDifferenceWeight);
        this.params.originalEdgesCountWeight = pMap.getFloat("prepare.ch.node.original_edge_count_weight", this.params.originalEdgesCountWeight);
        this.params.contractedNeighborsWeight = pMap.getFloat("prepare.ch.node.contracted_neighbors_weight", this.params.contractedNeighborsWeight);
    }

    @Override
    public void initFromGraph() {
        super.initFromGraph();
        this.ignoreNodeFilter = new IgnoreNodeFilter(this.prepareGraph, this.maxLevel);
        final DefaultEdgeFilter allFilter = DefaultEdgeFilter.allEdges(this.encoder);
        LevelEdgeFilter remainingNodesFilter = new LevelEdgeFilter(this.prepareGraph){

            @Override
            public final boolean accept(EdgeIteratorState edgeState) {
                return super.accept(edgeState) && allFilter.accept(edgeState);
            }
        };
        this.remainingEdgeExplorer = this.prepareGraph.createEdgeExplorer(remainingNodesFilter);
        this.prepareAlgo = new DijkstraOneToMany(this.prepareGraph, this.prepareWeighting, TraversalMode.NODE_BASED);
    }

    @Override
    public void prepareContraction() {
        this.meanDegree = this.prepareGraph.getEdges() / this.prepareGraph.getNodes();
    }

    @Override
    public void close() {
        super.close();
        this.prepareAlgo.close();
    }

    @Override
    public float calculatePriority(int node) {
        CalcShortcutsResult calcShortcutsResult = this.calcShortcutCount(node);
        int originalEdgesCount = calcShortcutsResult.originalEdgesCount;
        int contractedNeighbors = 0;
        int degree = 0;
        CHEdgeIterator iter = this.remainingEdgeExplorer.setBaseNode(node);
        while (iter.next()) {
            ++degree;
            if (!iter.isShortcut()) continue;
            ++contractedNeighbors;
        }
        int edgeDifference = calcShortcutsResult.shortcutsCount - degree;
        return this.params.edgeDifferenceWeight * (float)edgeDifference + this.params.originalEdgesCountWeight * (float)originalEdgesCount + this.params.contractedNeighborsWeight * (float)contractedNeighbors;
    }

    @Override
    public void contractNode(int node) {
        this.shortcuts.clear();
        long degree = this.findShortcuts(this.addScHandler.setNode(node));
        this.addedShortcutsCount += this.addShortcuts(this.shortcuts.keySet());
        this.meanDegree = (this.meanDegree * 2.0 + (double)degree) / 3.0;
    }

    @Override
    public String getStatisticsString() {
        return String.format(Locale.ROOT, "meanDegree: %.2f, dijkstras: %10s, mem: %10s", this.meanDegree, Helper.nf((long)this.dijkstraCount), this.prepareAlgo.getMemoryUsageAsString());
    }

    @Override
    boolean isEdgeBased() {
        return false;
    }

    private long findShortcuts(ShortcutHandler sch) {
        int maxVisitedNodes = this.getMaxVisitedNodesEstimate();
        long degree = 0L;
        CHEdgeIterator incomingEdges = this.inEdgeExplorer.setBaseNode(sch.getNode());
        while (incomingEdges.next()) {
            int fromNode = incomingEdges.getAdjNode();
            if (this.isContracted(fromNode)) continue;
            double incomingEdgeDistance = incomingEdges.getDistance();
            double incomingEdgeWeight = this.prepareWeighting.calcWeight(incomingEdges, true, -1);
            int incomingEdge = incomingEdges.getEdge();
            int inOrigEdgeCount = this.getOrigEdgeCount(incomingEdge);
            CHEdgeIterator outgoingEdges = this.outEdgeExplorer.setBaseNode(sch.getNode());
            this.prepareAlgo.clear();
            ++degree;
            while (outgoingEdges.next()) {
                int toNode = outgoingEdges.getAdjNode();
                if (this.isContracted(toNode) || fromNode == toNode) continue;
                double existingDirectWeight = incomingEdgeWeight + this.prepareWeighting.calcWeight(outgoingEdges, false, incomingEdges.getEdge());
                if (Double.isNaN(existingDirectWeight)) {
                    throw new IllegalStateException("Weighting should never return NaN values, in:" + this.getCoords(incomingEdges, this.prepareGraph) + ", out:" + this.getCoords(outgoingEdges, this.prepareGraph) + ", dist:" + outgoingEdges.getDistance());
                }
                if (Double.isInfinite(existingDirectWeight)) continue;
                double existingDistSum = incomingEdgeDistance + outgoingEdges.getDistance();
                this.prepareAlgo.setWeightLimit(existingDirectWeight);
                this.prepareAlgo.setMaxVisitedNodes(maxVisitedNodes);
                this.prepareAlgo.setEdgeFilter(this.ignoreNodeFilter.setAvoidNode(sch.getNode()));
                this.dijkstraSW.start();
                ++this.dijkstraCount;
                int endNode = this.prepareAlgo.findEndNode(fromNode, toNode);
                this.dijkstraSW.stop();
                if (endNode == toNode && this.prepareAlgo.getWeight(endNode) <= existingDirectWeight) continue;
                sch.foundShortcut(fromNode, toNode, existingDirectWeight, existingDistSum, outgoingEdges.getEdge(), this.getOrigEdgeCount(outgoingEdges.getEdge()), incomingEdge, inOrigEdgeCount);
            }
        }
        return degree;
    }

    private int addShortcuts(Collection<Shortcut> shortcuts) {
        int tmpNewShortcuts = 0;
        block0: for (Shortcut sc : shortcuts) {
            boolean updatedInGraph = false;
            CHEdgeIterator iter = this.outEdgeExplorer.setBaseNode(sc.from);
            while (iter.next()) {
                int status;
                if (!iter.isShortcut() || iter.getAdjNode() != sc.to || (status = iter.getMergeStatus(sc.flags)) == 0) continue;
                if (sc.weight >= this.prepareWeighting.calcWeight(iter, false, -1)) {
                    if (status != 2) continue block0;
                    break;
                }
                if (iter.getEdge() == sc.skippedEdge1 || iter.getEdge() == sc.skippedEdge2) {
                    throw new IllegalStateException("Shortcut cannot update itself! " + iter.getEdge() + ", skipEdge1:" + sc.skippedEdge1 + ", skipEdge2:" + sc.skippedEdge2 + ", edge " + iter + ":" + this.getCoords(iter, this.prepareGraph) + ", sc:" + sc + ", skippedEdge1: " + this.getCoords(this.prepareGraph.getEdgeIteratorState(sc.skippedEdge1, sc.from), this.prepareGraph) + ", skippedEdge2: " + this.getCoords(this.prepareGraph.getEdgeIteratorState(sc.skippedEdge2, sc.to), this.prepareGraph) + ", neighbors:" + GHUtility.getNeighbors(iter));
                }
                iter.setFlagsAndWeight(sc.flags, sc.weight);
                iter.setDistance(sc.dist);
                iter.setSkippedEdges(sc.skippedEdge1, sc.skippedEdge2);
                this.setOrigEdgeCount(iter.getEdge(), sc.originalEdges);
                updatedInGraph = true;
                break;
            }
            if (updatedInGraph) continue;
            int scId = this.prepareGraph.shortcut(sc.from, sc.to, sc.flags, sc.weight, sc.dist, sc.skippedEdge1, sc.skippedEdge2);
            this.setOrigEdgeCount(scId, sc.originalEdges);
            ++tmpNewShortcuts;
        }
        return tmpNewShortcuts;
    }

    private CalcShortcutsResult calcShortcutCount(int node) {
        this.findShortcuts(this.calcScHandler.setNode(node));
        return this.calcScHandler.calcShortcutsResult;
    }

    private String getCoords(EdgeIteratorState edge, Graph graph) {
        NodeAccess na = graph.getNodeAccess();
        int base = edge.getBaseNode();
        int adj = edge.getAdjNode();
        return base + "->" + adj + " (" + edge.getEdge() + "); " + na.getLat(base) + "," + na.getLon(base) + " -> " + na.getLat(adj) + "," + na.getLon(adj);
    }

    @Override
    public long getAddedShortcutsCount() {
        return this.addedShortcutsCount;
    }

    @Override
    public long getDijkstraCount() {
        return this.dijkstraCount;
    }

    @Override
    public float getDijkstraSeconds() {
        return this.dijkstraSW.getCurrentSeconds();
    }

    private int getMaxVisitedNodesEstimate() {
        return (int)this.meanDegree * 100;
    }

    public static class Params {
        private float edgeDifferenceWeight = 10.0f;
        private float originalEdgesCountWeight = 1.0f;
        private float contractedNeighborsWeight = 1.0f;
    }

    private static class CalcShortcutsResult {
        int originalEdgesCount;
        int shortcutsCount;

        private CalcShortcutsResult() {
        }
    }

    private class AddShortcutHandler
    implements ShortcutHandler {
        int node;

        private AddShortcutHandler() {
        }

        @Override
        public int getNode() {
            return this.node;
        }

        public AddShortcutHandler setNode(int node) {
            NodeBasedNodeContractor.this.shortcuts.clear();
            this.node = node;
            return this;
        }

        @Override
        public void foundShortcut(int fromNode, int toNode, double existingDirectWeight, double existingDistSum, int outgoingEdge, int outOrigEdgeCount, int incomingEdge, int inOrigEdgeCount) {
            Shortcut sc = new Shortcut(fromNode, toNode, existingDirectWeight, existingDistSum);
            if (NodeBasedNodeContractor.this.shortcuts.containsKey(sc)) {
                return;
            }
            Shortcut tmpSc = new Shortcut(toNode, fromNode, existingDirectWeight, existingDistSum);
            Shortcut tmpRetSc = (Shortcut)NodeBasedNodeContractor.this.shortcuts.get(tmpSc);
            if (tmpRetSc != null && tmpRetSc.skippedEdge2 == incomingEdge && tmpRetSc.skippedEdge1 == outgoingEdge) {
                tmpRetSc.flags = PrepareEncoder.getScDirMask();
                return;
            }
            Shortcut old = NodeBasedNodeContractor.this.shortcuts.put(sc, sc);
            if (old != null) {
                throw new IllegalStateException("Shortcut did not exist (" + sc + ") but was overwriting another one? " + old);
            }
            sc.skippedEdge1 = incomingEdge;
            sc.skippedEdge2 = outgoingEdge;
            sc.originalEdges = inOrigEdgeCount + outOrigEdgeCount;
        }
    }

    private class CalcShortcutHandler
    implements ShortcutHandler {
        int node;
        CalcShortcutsResult calcShortcutsResult = new CalcShortcutsResult();

        private CalcShortcutHandler() {
        }

        @Override
        public int getNode() {
            return this.node;
        }

        public CalcShortcutHandler setNode(int node) {
            this.node = node;
            this.calcShortcutsResult.originalEdgesCount = 0;
            this.calcShortcutsResult.shortcutsCount = 0;
            return this;
        }

        @Override
        public void foundShortcut(int fromNode, int toNode, double existingDirectWeight, double distance, int outgoingEdge, int outOrigEdgeCount, int incomingEdge, int inOrigEdgeCount) {
            ++this.calcShortcutsResult.shortcutsCount;
            this.calcShortcutsResult.originalEdgesCount += inOrigEdgeCount + outOrigEdgeCount;
        }
    }

    private static interface ShortcutHandler {
        public void foundShortcut(int var1, int var2, double var3, double var5, int var7, int var8, int var9, int var10);

        public int getNode();
    }

    private static class Shortcut {
        int from;
        int to;
        int skippedEdge1;
        int skippedEdge2;
        double dist;
        double weight;
        int originalEdges;
        int flags = PrepareEncoder.getScFwdDir();

        public Shortcut(int from, int to, double weight, double dist) {
            this.from = from;
            this.to = to;
            this.weight = weight;
            this.dist = dist;
        }

        public int hashCode() {
            int hash = 5;
            hash = 23 * hash + this.from;
            hash = 23 * hash + this.to;
            return 23 * hash + (int)(Double.doubleToLongBits(this.weight) ^ Double.doubleToLongBits(this.weight) >>> 32);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Shortcut other = (Shortcut)obj;
            return this.from == other.from && this.to == other.to && Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(other.weight);
        }

        public String toString() {
            String str = this.flags == PrepareEncoder.getScDirMask() ? this.from + "<->" : this.from + "->";
            return str + this.to + ", weight:" + this.weight + " (" + this.skippedEdge1 + "," + this.skippedEdge2 + ")";
        }
    }
}

