/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.PathBidirRef;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.CHEdgeIteratorState;
import java.util.Locale;

public class Path4CH
extends PathBidirRef {
    private final Graph routingGraph;

    public Path4CH(Graph routingGraph, Graph baseGraph, Weighting weighting) {
        super(baseGraph, weighting);
        this.routingGraph = routingGraph;
    }

    @Override
    protected final void processEdge(int edgeId, int endNode, int prevEdgeId) {
        this.expandEdge(this.getEdge(edgeId, endNode), false);
    }

    private void expandEdge(CHEdgeIteratorState edge, boolean reverse) {
        if (!edge.isShortcut()) {
            this.distance += edge.getDistance();
            this.time += this.weighting.calcMillis(edge, reverse, -1);
            this.addEdge(edge.getEdge());
            return;
        }
        this.expandSkippedEdges(edge.getSkippedEdge1(), edge.getSkippedEdge2(), edge.getBaseNode(), edge.getAdjNode(), reverse);
    }

    private void expandSkippedEdges(int skippedEdge1, int skippedEdge2, int from, int to, boolean reverse) {
        if (from != to) {
            CHEdgeIteratorState sk2to;
            if (this.reverseOrder == reverse) {
                int tmp = from;
                from = to;
                to = tmp;
            }
            if ((sk2to = this.getEdge(skippedEdge2, to)) != null) {
                this.expandEdge(sk2to, !this.reverseOrder);
                this.expandEdge(this.getEdge(skippedEdge1, from), this.reverseOrder);
            } else {
                this.expandEdge(this.getEdge(skippedEdge1, to), !this.reverseOrder);
                this.expandEdge(this.getEdge(skippedEdge2, from), this.reverseOrder);
            }
        } else {
            CHEdgeIteratorState sk1 = this.getEdge(skippedEdge1, from);
            CHEdgeIteratorState sk2 = this.getEdge(skippedEdge2, from);
            if (sk1.getAdjNode() == sk1.getBaseNode() || sk2.getAdjNode() == sk2.getBaseNode()) {
                throw new IllegalStateException(String.format(Locale.ROOT, "error: detected edge where both skipped edges are loops. from: %d, to: %d, skip-edge1: %d, skip-edge2: %d, reverse: %b", from, to, skippedEdge1, skippedEdge2, reverse));
            }
            if (!this.reverseOrder) {
                this.expandEdge(sk1, !reverse);
                this.expandEdge(sk2, reverse);
            } else {
                this.expandEdge(sk2, reverse);
                this.expandEdge(sk1, !reverse);
            }
        }
    }

    private CHEdgeIteratorState getEdge(int edgeId, int adjNode) {
        return (CHEdgeIteratorState)this.routingGraph.getEdgeIteratorState(edgeId, adjNode);
    }
}

